#ifndef RESULT_H
#define RESULT_H

#include "compiler.h"
#include "objtypes.h"
#include "resultlist.h"
#include "blob.h"
#include "charstring.h"

typedef struct result {
  objectHeader header;
  union {
    bool b;
    short s;
    int i;
    long l;
    float f;
    double d;
    resultList *lp;
    blob *bbp;
    errorCode e;
  } v;
#ifdef DETECT_RESULT_LEAKS
  struct result *prev, *next;
#endif /* DETECT_RESULT_LEAKS */
} result;

#define resultIsVoid(rp)	(datatypeResolve(objectDataType(rp)) == dtVoid)
#define resultIsBoolean(rp)	(datatypeResolve(objectDataType(rp)) == dtBoolean)
#define resultIsShort(rp)	(datatypeResolve(objectDataType(rp)) == dtShort)
#define resultIsInteger(rp)	(datatypeResolve(objectDataType(rp)) == dtInteger)
#define resultIsLong(rp)	(datatypeResolve(objectDataType(rp)) == dtLong)
#define resultIsFloat(rp)	(datatypeResolve(objectDataType(rp)) == dtFloat)
#define resultIsDouble(rp)	(datatypeResolve(objectDataType(rp)) == dtDouble)
#define resultIsList(rp)	(datatypeResolve(objectDataType(rp)) == dtList)
#define resultIsBlobPtr(rp)	(datatypeResolve(objectDataType(rp)) == dtBlob)
#define resultIsError(rp)	(datatypeResolve(objectDataType(rp)) == dtError)

#define resultSameType(r1, r2)	(r1->header.dtype == r2->header.dtype)

#define resultBoolean(rp)	(const bool )((rp)->v.b)
#define resultShort(rp)		(const short )((rp)->v.s)
#define resultInteger(rp)	(const int )((rp)->v.i)
#define resultLong(rp)		(const long )((rp)->v.l)
#define resultFloat(rp)		(const float )((rp)->v.f)
#define resultDouble(rp)	(const double )((rp)->v.d)
#define resultListPtr(rp)	(rp)->v.lp
#define resultBlobPtr(rp)	(rp)->v.bbp
#define resultError(rp)		(const errorCode )((rp)->v.e)

#define resultValue(rp)		\
  (objectDataType(rp) == dtBoolean ? (rp)->v.b : \
   (objectDataType(rp) == dtShort ? (rp)->v.s : \
    (objectDataType(rp) == dtInteger ? (rp)-> v.i : \
     (objectDataType(rp) == dtLong ? (rp)-> v.l : \
      (objectDataType(rp) == dtFloat ? (rp)-> v.f : \
       (objectDataType(rp) == dtDouble ? (rp)-> v.d : \
	(objectDataType(rp) == dtList ? (rp)-> v.lp : \
	 (objectDataType(rp) == dtBlob ? (rp)-> v.bbp : \
	  (objectDataType(rp) == dtError ? (rp)-> v.e : 0)

#define resultSetType(rp, dt)	objectSetDataType(rp, dt)

#define resultSetVoid(rp)	objectSetDataType(rp, dtVoid)
#define resultSetBoolean(rp, x)	\
	(objectSetDataType(rp, dtBoolean), (rp)->v.b = (x))
#define resultSetShort(rp, x)	\
	(objectSetDataType(rp, dtShort), (rp)->v.s = (x))
#define resultSetInteger(rp, x)	\
	(objectSetDataType(rp, dtInteger), (rp)->v.i = (x))
#define resultSetLong(rp, x)	(objectSetDataType(rp, dtLong), (rp)->v.l = (x))
#define resultSetFloat(rp, x)	\
	(objectSetDataType(rp, dtFloat), (rp)->v.f = (x))
#define resultSetDouble(rp, x)	\
	(objectSetDataType(rp, dtDouble), (rp)->v.d = (x))
#define resultSetListPtr(rp, x)	\
	(objectSetDataType(rp, dtList), (rp)->v.lp = (x))
#define resultSetBlobPtr(rp, xbbp, xdt)	\
	(objectSetDataType(rp, xdt), (rp)->v.bbp = (xbbp))
#define resultSetError(rp, x)	\
	(objectSetDataType(rp, dtError), (rp)->v.e = (x))

#define resultCount(rp, i)	(i ? 0 : 1)
#define resultDepth(rp, d)	(d)+1

result *resultCreate P((datatype type, ...));
result *resultCopy P((const result *rp));
int resultCompare P((const result *rp1, const result *rp2));
const result **resultNodePtr P((const result **rpp, int *count, int nodeNum,
				int internal, datatype *typeptr));
int resultToString P((const result *rp, charString *cstr));
void resultFree P((result *rp));
#ifdef DETECT_RESULT_LEAKS
int resultFoundLeak P((NOARGS));
#endif /* DETECT_RESULT_LEAKS */
#ifdef KEEP_ALLOCATED_MEMORY
void resultFreeStack P((NOARGS));
#endif /* KEEP_ALLOCATED_MEMORY */

#endif /* RESULT_H */
