#ifndef OPERATOR_H
#define OPERATOR_H

#include "compiler.h"
#include "charstring.h"
#include "object.h"

typedef struct operator {
  objectHeader header;
  const struct operatorSrc *src;
  int numArgs, maxArgs;
  object **arglist;
  result **reslist;
} operator;

#define operatorName(op)	operatorSrcName((op)->src)
#define operatorSource(op)	(op)->src
#define operatorNumArgs(op)	((const int )((op)->numArgs))
#define operatorArg(op, i)	((const object *)((op)->arglist[i]))

#define operatorToString(op, cstr)	\
				((op)->src && \
				 operatorSrcPrintProc((op)->src) ? \
				 operatorSrcPrintProc((op)->src)(op, cstr) : \
				 operatorToLispString(op, 0, cstr))
#define operatorCheckpoint(op, cstr)	\
				operatorToLispString(op, 1, cstr)

operator *operatorCreate P((const struct operatorSrc *osp, int numArgs));
int operatorAddArg P((operator *op, object *arg));
operator *operatorCopy P((const operator *op, int everything));
result *simpleOperatorEval P((const operator *op, void *envp));
result *complexOperatorEval P((const operator *op, void *envp));
int operatorCount P((const operator *op, int internal));
int operatorDepth P((const operator *op, int currentDepth));
int operatorCompare P((const operator *op1, const operator *op2));
object **operatorNodePtr P((const operator **opp, int *count, int nodeNum,
			    int internal, datatype *typeptr));
int operatorToLispString P((const operator *op, int checkpoint,
			    charString *cstr));
void operatorFree P((operator *op));

#endif /* OPERATOR_H */
