#ifndef OBJECT_H
#define OBJECT_H

#include "compiler.h"
#include "objtypes.h"

typedef struct object {
  objectHeader header;
} object;

#define objectType(op)			(const objecttype )((op)->header.otype)
#define objectDataType(op)		(const datatype )((op)->header.dtype)

#define objectSetType(op, ot)		(op)->header.otype = (ot)
#define objectSetDataType(op, dt)	(op)->header.dtype = (dt)

#define objectIsOperator(op)		((op)->header.otype == otSimpleOperator || \
					 (op)->header.otype == otComplexOperator)

#define objectToString(op, cstr)	objectStrChkpt(op, 0, cstr)
#define objectCheckpoint(op, cstr)	objectStrChkpt(op, 1, cstr)

#include "charstring.h"
#include "result.h"

object *objectCopy P((const object *ob, int everything));
result *objectEval P((const object *ob, void *envp));
int objectCount P((const object *ob, int internal));
int objectDepth P((const object *ob, int currentDepth));
int objectCompare P((const object *ob1, const object *ob2));
object **objectNodePtr P((const object **obpp, int *count, int nodeNum,
			  int internal, datatype *typeptr));
int objectStrChkpt P((const object *ob, bool checkpoint, charString *cstr));
void objectFree P((object *ob));

#endif /* OBJECT_H */
