#ifndef GLOBAL_H
#define GLOBAL_H

#include "objectlist.h"
#include "pmrand.h"
#include "program.h"
#include "population.h"

typedef int (evalFunction) P((void *, int));

typedef struct global {
  int numPops, maxPops;
  population **popp;
  initializeFunction *popInitFunc;
  int generations;
  int checkptFreq;
  const char *checkptName;
  int countUnique;
  int randomSeed;
  int verbose;
  evalFunction *evalFunc;
  int useSingleEnvironment;
  int useFinalResult;
} global;

typedef struct progInfo {
  population *pop;
  program *pp;
  void *envp;
  result *rp;
  int hits;
  double raw, std;
} progInfo;

#define globalPopulation(gp, i)			(gp)->popp[i]

#define globalSetNumberOfPopulations(gp, n)	\
	((global *)gp)->numPops = (n)
#define globalSetCheckpointFrequency(gp, f)	\
	((global *)gp)->checkptFreq = (f)
#define globalSetCheckpointName(gp, n)		\
	((global *)gp)->checkptName = (n)
#define globalClearCountUniqueMode(gp)		\
	((global *)gp)->countUnique = 0
#define globalSetCountUniqueMode(gp)		\
	((global *)gp)->countUnique = 1
#define globalSetGenerations(gp, g)		\
	((global *)gp)->generations = (g)
#define globalSetRandomNumberSeed(gp, r)	\
	(((global *)gp)->randomSeed = (r), srnd(((global *)gp)->randomSeed))
#define globalClearVerboseMode(gp)		((global *)gp)->verbose = 0
#define globalSetVerboseMode(gp)		((global *)gp)->verbose = 1
#define globalSetEvalFunc(gp, func)		\
	((global *)gp)->evalFunc = (func)
#define globalClearSingleEnvironmentFlag(gp)	\
	((global *)gp)->useSingleEnvironment = 0
#define globalSetSingleEnvironmentFlag(gp)	\
	((global *)gp)->useSingleEnvironment = 1
#define globalClearFinalResultFlag(gp)		\
	((global *)gp)->useFinalResult = 0
#define globalSetFinalResultFlag(gp)		\
	((global *)gp)->useFinalResult = 1

#define globalCheckpointFrequency(gp)		\
	((const int )((const global *)gp)->checkptFreq)
#define globalCheckpointName(gp)		\
	((const char *)((const global *)gp)->checkptName)
#define globalCountUniqueMode(gp)		\
	(((const global *)gp)->countUnique != 0)
#define globalGenerations(gp)			\
	((const int )((const global *)gp)->generations)
#define globalRandomNumberSeed(gp)		\
	((const int )((const global *)gp)->randomSeed)
#define globalVerboseMode(gp)			\
	((const int )((const global *)gp)->verbose != 0)
#define globalEval(gp, num)			\
	((global *)gp)->evalFunc(gp, num)

#define globalClearAlwaysEvaluateMode(gp)	\
	globalSetPopulationOption(gp, poClearAlwaysEvaluateMode)
#define globalSetAlwaysEvaluateMode(gp)		\
	globalSetPopulationOption(gp, poSetAlwaysEvaluateMode)
#define globalSetInitialTreeDepth(gp, x)	\
	globalSetPopulationOption(gp, poInitialTreeDepth, x)
#define globalSetMaximumMutationDepth(gp, x)	\
	globalSetPopulationOption(gp, poMaximumMutationDepth, x)
#define globalSetMaximumTreeDepth(gp, x)	\
	globalSetPopulationOption(gp, poMaximumTreeDepth, x)
#define globalSetOverselectionPercentage(gp, x)	\
	globalSetPopulationOption(gp, poOverselectionPercentage, x)
#define globalSetParsimony(gp, x)		\
	globalSetPopulationOption(gp, poParsimony, x)
#define globalSetPopulationSize(gp, x)		\
	globalSetPopulationOption(gp, poSize, x)
#define globalSetParentSelectionMethod(gp, x)	\
	globalSetPopulationOption(gp, poProgramCreationMethod, x)
#define globalSetProgramCreationMethod(gp, x)	\
	globalSetPopulationOption(gp, poProgramCreationMethod, x)
#define globalSetTournamentRounds(gp, x)	\
	globalSetPopulationOption(gp, poTournamentRounds, x)

#define globalEvalProgram(gp, num, pp)		globalEvalSingle(gp, num, pp)

global *globalCreate P((initializeFunction *initFunc));
void globalSetPopulationOption P((const global *, populationOption, ...));
void globalDumpParams P((const global *gp));
void globalGenesis P((global *gp));
void globalBreed P((global *gp));
void globalEvalSingle P((global *gp, int popNum, program *pp));
int globalDiscreteEval P((global *gp, int genNum));
void globalEvalMultiple P((global *gp, progInfo info[], int numInfo));
int globalCoEval P((global *gp, int genNum));
global * globalReadCheckpointFile P((const char *name,
				     initializeFunction *initFunc,
				     int *genPtr));
int globalWriteCheckpointFile P((const global *gp, int gen));
int globalCompare P((const global *, const global *));
void globalDump P((const global *gp, int gen));
void globalLoop P((global *gp, int firstGen));
void globalFree P((global *gp));

#endif /* GLOBAL_H */
