#ifndef CONSTANTSRC_H
#define CONSTANTSRC_H

#include "compiler.h"
#include "objtypes.h"
#include "constant.h"
#include "charstring.h"
#include "result.h"

typedef union bounds {
  int i;
  double d;
} bounds;

typedef struct constantSrc {
  objectHeader header;
  bounds min, max;
} constantSrc;

#define constantSrcCount(csp, i)	(i ? 0 : 1)
#define constantSrcDepth(csp, d)	(d)+1

#define booleanSrcCreate()		constantSrcCreate(dtBoolean)
#define shortSrcCreate(low, high)	\
	constantSrcCreate(dtShort, (int )(low), (int )(high))
#define integerSrcCreate(low, high)	\
	constantSrcCreate(dtInteger, (int )(low), (int )(high))
#define floatSrcCreate(low, high)	\
	constantSrcCreate(dtFloat, (double )(low), (double )(high))
#define doubleSrcCreate(low, high)	\
	constantSrcCreate(dtDouble, (double )(low), (double )(high))
#define blobSrcCreate(dtype)		constantSrcCreate(dtype)

constantSrc *constantSrcCreate P((datatype dt, ...));
constant *constantSrcCopy P((const constantSrc *csp));
result *constantSrcEval P((const constantSrc *csp));
int constantSrcCompare P((const constantSrc *csp1, const constantSrc *csp2));
const constantSrc **constantSrcNodePtr P((const constantSrc **cspp, int *count,
					  int nodenum, int internal,
					  datatype *typeptr));
int constantSrcToString P((const constantSrc *csp, charString *cstr));
void constantSrcFree P((constantSrc *csp));
#ifdef KEEP_ALLOCATED_MEMORY
void constantSrcFreeStack P((NOARGS));
#endif /* KEEP_ALLOCATED_MEMORY */

#endif /* CONSTANTSRC_H */
