#ifndef CKPTIO_H
#define CKPTIO_H

#include "charstring.h"
#include "program.h"
#include "population.h"
#include "compiler.h"

#define writeBoolean(out, name, val)	\
  (fprintf(out, "%s %s\n", (name), (val) ? "T" : "F") == EOF)
#define writeInteger(out, name, val)	\
  (fprintf(out, "%s %d\n", (name), (val)) == EOF)
#define writeDouble(out, name, val)	\
  (fprintf(out, "%s %f\n", (name), (val)) == EOF)

int readCreationMethod P((FILE *, charString *,
				 programCreationMethod *));
int readSelectionMethod P((FILE *, charString *,
				  parentSelectionMethod *));
int readBoolean P((FILE *, charString *, const char *, int *));
int readInteger P((FILE *, charString *, const char *, int *));
int readDouble P((FILE *, charString *, const char *, double *));
int writeSelectionMethod P((FILE *, parentSelectionMethod));
int writeCreationMethod P((FILE *, programCreationMethod));

#endif /* CKPTIO_H */
