#ifndef BLOB_H
#define BLOB_H

#include "compiler.h"
#include "charstring.h"

typedef void *blob;

#define blobCount(bbp, i)	(i ? 0 : 1)
#define blobDepth(bbp, d)	(d)+1

#include "objtypes.h"

blob *blobCreate P((datatype dtype));
blob *blobCopy P((const blob *bbp, datatype dtype));
int blobCompare P((const blob *bbp1, const blob *bbp2, datatype dtype));
blob *blobParse P((const char **sp, datatype *dtp));
int blobToString P((const blob *bbp, datatype dtype, charString *cstr));
void blobFree P((blob *bbp, datatype dtype));
#endif /* BLOB_H */
