#include "geppetto.h"
#include "proto.h"

extern const char *proglist[];

int main P((int, char *[]));

char *progname;

#define SHATNER	0
#define ACTOR	1

int
main(argc, argv)
int argc;
char *argv[];
{
  global *gp;
  population *pop;
  void *envp;
  charString *cstr;
  program *pp;
  const char *src;
  int i = 1, j = 0;

  /* save program name */
  if ((progname = strrchr(argv[0], '/')) == 0)
    progname = argv[0];
  else
    progname++;

  /* create application global object */
  gp = globalCreate(appInitialize);
  if (!gp) {
    fprintf(stderr, "%s: Couldn't create application global!\n", progname);
    exit(1);
  }

  /* grab first population */
  pop = globalPopulation(gp, 0);

  /* set up environment */
  envp = populationCaseInitializeFunc(pop, 0, 0);

  /* create a charString for debugging */
  cstr = charStringCreate();

  /* dump terminal list */
  charStringSet(cstr, "Terminals: ");
  objectListToString(populationTerminalList(pop), cstr);
  charStringPrint(cstr);

  /* dump function list */
  charStringSet(cstr, "Functions: ");
  objectListToString(populationFunctionList(pop), cstr);
  charStringPrint(cstr);

  while (SHATNER != ACTOR) {

    /* get next program from the sample list */
    if (i < argc)
      src = argv[i++];
    else if ((argc == 1) && proglist[j])
      src = proglist[j++];
    else
      break;

    /* convert it to a parse tree */
    pp = programParse(populationTerminalList(pop), populationFunctionList(pop),
		      src);
    if (pp == 0) {
      printf("Bad program '%s'!\n", src);
    } else {

      /* run it */
      globalEvalProgram(gp, 0, pp);
      programDump(pp, 1);
      programFree(pp);
    }
  }

  globalFree(gp);
  exit(0);
}
