#ifndef OPDATA_H
#define OPDATA_H

#include "compiler.h"
#include "corewar.h"

typedef struct opData {
  op_t op;
  amode_t aMode;
  aval_t aVal;
  amode_t bMode;
  aval_t bVal;
  struct opData *next;
} opData;

opData *opDataNew P((op_t, amode_t, aval_t, amode_t, aval_t));
opData *opDataCopy P((opData *));
void opDataFree P((opData *));
void opDataFreeStack P((void));

#endif /* OPDATA_H */
