#include <stdio.h>
#include "opdata.h"
#ifdef INCLUDE_MALLOC_H
#include <malloc.h>
#endif
#include "proto.h"

#ifdef KEEP_ALLOCATED_MEMORY
static opData *freeStack = 0;
#endif /* KEEP_ALLOCATED_MEMORY */

opData *
opDataNew(op, aMode, aVal, bMode, bVal)
op_t op;
amode_t aMode;
aval_t aVal;
amode_t bMode;
aval_t bVal;
{
  opData *odp;

  /* create a new instance of opData */
#ifdef KEEP_ALLOCATED_MEMORY
  if (freeStack) {
    odp = freeStack;
    freeStack = *(opData **)odp;
  } else
#endif /* KEEP_ALLOCATED_MEMORY */
    odp = (opData *)malloc(sizeof(opData));

  /* fill in info */
  if (odp) {
    odp->op = op;
    odp->aMode = aMode;
    odp->aVal = aVal;
    odp->bMode = bMode;
    odp->bVal = bVal;
    odp->next = NULL;
  }

  return(odp);
}

opData *
opDataCopy(odp)
opData *odp;
{
  opData *nodp;

  /* create a new instance of opData */
#ifdef KEEP_ALLOCATED_MEMORY
  if (freeStack) {
    nodp = freeStack;
    freeStack = *(opData **)nodp;
  } else
#endif /* KEEP_ALLOCATED_MEMORY */
    nodp = (opData *)malloc(sizeof(opData));

  /* fill in info */
  if (nodp) {
    nodp->op = odp->op;
    nodp->aMode = odp->aMode;
    nodp->aVal = odp->aVal;
    nodp->bMode = odp->bMode;
    nodp->bVal = odp->bVal;
    if (odp->next)
      nodp->next = opDataCopy(odp->next);
    else
      nodp->next = NULL;
  }

  return(nodp);
}

void
opDataFree(odp)
opData *odp;
{
  opData *next;

  do {
    next = odp->next;
#ifdef KEEP_ALLOCATED_MEMORY
    *(opData **)odp = freeStack;
    freeStack = odp;
#else /* !KEEP_ALLOCATED_MEMORY */
    free(odp);
#endif /* KEEP_ALLOCATED_MEMORY */
    odp = next;
  } while (odp);
}

#ifdef KEEP_ALLOCATED_MEMORY
void
opDataFreeStack()
{
  opData *odp;

  while (freeStack) {
    odp = freeStack;
    freeStack = *(opData **)odp;
    free(odp);
  }
}
#endif /* KEEP_ALLOCATED_MEMORY */
