/* corewar.h */
#ifndef COREWAR_H
#define COREWAR_H

/* This program was written by Bill Shubert.  Give it away all you want and
 *   modify it all you want, but just to be nice keep my name around.
 */

#define NO_DISP

#define  STR_MAXLEN  80
#define  STR_ERRLEN  1024

#define  VERSION  "KotH Corewar V3.1 by Bill Shubert - 1 November 1992"

#define  FALSE  0
#define  TRUE   1

typedef enum {
	op_dat, op_mov, op_add, op_sub, op_jmp, op_jmz, op_jmn, op_djn, op_cmp,
	op_spl, op_slt, op_end, op_equ, op_nogood} op_t;
#define  op_realop(x)  ((op_t)x <= op_slt)

typedef enum  {
	am_imm, am_dir, am_ind, am_dec, am_inc} amode_t;

#define  JTINDEX(op, am1, am2) \
	(((((unsigned)op * 5) + (unsigned)am1) * 5) + (unsigned)am2)
#define  JTOP(index)   (op_t)(index / 25)
#define  JTAM1(index)  (amode_t)((index / 5) % 5)
#define  JTAM2(index)  (amode_t)(index % 5)

typedef unsigned  aval_t;
#define  AVAL_NOGOOD  ((aval_t)-1)
#define  AVAL_PROGID  ((aval_t)-2)

typedef struct  thread_struct  {
	aval_t  addr;
	struct thread_struct  *next, *prev;
} thread_t;

typedef struct  core_el_struct  {
  int  (*instr)(thread_t *th, struct core_el_struct *core,
	              aval_t w_radius, aval_t coresize, aval_t xeq_addr,
	              aval_t op1, aval_t op2);
	aval_t val1;
	aval_t val2;
	unsigned  index;
} core_el_t;

typedef int  intfunc(thread_t *th, core_el_t *core,
										 aval_t w_radius, aval_t coresize, aval_t xeq_addr,
										 aval_t op1, aval_t op2);
typedef intfunc  *pintfunc;

typedef struct  program_struct  {
	aval_t  startaddr;
	aval_t  proglen;
	core_el_t  *listing;
	char  author[STR_MAXLEN], retaddr[STR_MAXLEN], pname[STR_MAXLEN],
	      fname[STR_MAXLEN];
} program_t;

/* Data tables useful in more than one module. */
extern char  cwerrstr[STR_ERRLEN];
extern const char  *opnames[], *amodenames[];
extern core_el_t  *core;
extern pintfunc  jmptable[];


/* Display stuff. */
#define  DI_MAXPLAYERS  6
#define  DI_PLSIZ  3
#define  DI_EMPTY  0
#define  DI_DEAD   1
#define  DI_DAT    2
#define  DI_RAN    3
#define  DI_XEQ    4


/* Options that affect play */
extern aval_t  coresize;
extern aval_t  maxprogsize;
extern unsigned  maxthreads;
extern unsigned  max_cycles;
extern unsigned  amode_restrict;
extern unsigned  postinc;
extern unsigned  rounds;
extern unsigned  w_radius;
extern unsigned  interactive;
extern unsigned  split_id;

#ifdef hpux
#undef srandom
#define srandom(seed)	srand(seed)
#undef random
#define random()	rand()
#endif

/* From "sim.c" */
extern unsigned  new_core(void),
                 load_core(program_t *prog, aval_t addr, unsigned id),
	               sim_cyc(void);
extern int  simulate(unsigned cycles, unsigned progs);
extern int  proc_count(unsigned id);
extern aval_t  proc_exec(unsigned id);
extern void  free_core(void), clear_core(aval_t start, unsigned len, int id),
             set_first(int id);
extern aval_t  sim_nextaddr(void);
extern int   sim_nextplayer(void);

/* From "ldaddr.c" */
extern void  ld_init(unsigned maxloads);
extern aval_t  ld_addr(unsigned ldnum), ld_undo(unsigned ldnum);

/* From "disp.c" */
extern void  di_init(char *progname, char *geometry, char *dpyname, int iconic,
                     unsigned fightlen);
extern void  di_drawaddr(aval_t addr, int picid);

#endif /* COREWAR_H */
