#!/usr/sww/bin/perl

$program = 0;
while (<>) {
  chop;
  if ($program) {
    $LINE = $_;
    print $LINE,"\n";
    &disasm();
  } elsif (/^programs$/) {
    $program = 1;
  }
}

exit 0;

sub disasm {
  local($op);
  local(@arg1, @arg2);

  if ($LINE =~ s/^\(assemble\s+//) {
    &doOp();
    print STDERR "Unbalanced parens!\n" if ($LINE !~ s/^\)$//);
  }
  print "\n";
}

sub doOp {
  local($op, $n);
  local(@arg1, @arg2);

  if ($LINE =~ s/^\(([A-Z][A-Z][A-Z])\s+//) {
    $op = $1;
    @arg1 = &doMode();
    @arg2 = &doMode();
    $LINE =~ s/^\)\s*//;
    printf "    %3s %s%4d, %s%4d\n", $op, $arg1[0], $arg1[1],
		$arg2[0], $arg2[1];
  } elsif ($LINE =~ s/\(progn([23])\s+//) {
    $n = $1;
    while ($n > 0) {
      &doOp();
      $n--;
    }
    $LINE =~ s/^\)\s*//;
  } else {
    $LINE =~ /^([^\s]*)/;
    print STDERR "Unknown operator \"$1\"!\n";
    exit 1;
  }
}

sub doMode {
  local($mode, $val);

  if ($LINE =~ s/^\(([\#\$\<\@])\s+//) {
    $mode = $1;
    $val = &doVal();
    $LINE =~ s/^\)\s*//;
  } else {
    $LINE =~ /^([^\s]*)/;
    print STDERR "Unknown mode \"$1\"!\n";
    exit 1;
  }
  ($mode, $val);
}

sub doVal {
  local($op, $arg1, $arg2);

  if ($LINE =~ s/^([0-9]+)\s*//) {
    return $1;
  } elsif ($LINE =~ s/^\(([\+\-\*\/])\s+//) {
    $op = $1;
    $arg1 = &doVal();
    $arg2 = &doVal();
    $LINE =~ s/^\)\s*//;
    return 'ERR' if ($arg1 eq 'ERR' || $arg2 eq 'ERR');
    if ($op eq '+') {
      return $arg1 + $arg2;
    } elsif ($op eq '-') {
      return $arg1 - $arg2;
    } elsif ($op eq '*') {
      return $arg1 * $arg2;
    } elsif ($op eq '/') {
      return 'ERR' if ($arg2 == 0);
      return $arg1 / $arg2;
    }
  }
  return 'ERR';
}
