#!/bin/sh
#
# run a Geppetto application for a specified number of repetitions

# make sure we got the right number of args
#
if [ $# -eq 0 -o $# -gt 2 ]; then
  echo "Usage: $0 app [reps]"
  exit 1;
fi

# make sure we can find the application
#
APP=`which $1`
if [ "$APP" = "" ]; then
  echo "Couldn't find $1"
  exit 2
fi

# make sure we can run the application
#
if [ ! -x "$APP" ]; then
  echo "Couldn't run $APP"
  exit 3
fi

# set up number of reps
#
REPS=100
if [ $# -eq 2 ]; then
  REPS=$2
  if [ "$REPS" -le 0 ]; then
    echo "Number of reps must be greater than 0"
    exit 4
  fi
fi

# repeatedly run the application
#
RUN=0
while [ $RUN -lt $REPS ]; do
  nice -19 $APP | awk '
BEGIN {
  run='$RUN'; seed=0; lastGen=0; bestGen=0; time=0;
}
/^[ \t]*Random Seed: [0-9]+/ {
  seed=$3;
}
/^Generation [0-9]+ Summary:/ {
  lastGen=$2;
}
/^Best program found on generation [0-9]+/ {
  bestGen=$6;
}
/^Elapsed time = [0-9.]+ seconds/ {
  time=$4;
}
END {
  printf "%3d: Seed=%s, Last=%s, Best=%s, Time=%s\n", run, seed, lastGen, bestGen, time;
}'
  RUN=`expr $RUN + 1`
done

exit 0
