#ifndef RESULT_H
#define RESULT_H

#include "compiler.h"
#include "objtypes.h"
#include "resultlist.h"
#include "blob.h"
#include "charstring.h"

typedef struct result {
  objecttype otype;
  datatype dtype;
  union {
    bool b;
    short s;
    int i;
    long l;
    float f;
    double d;
    resultList *lp;
    blob *bbp;
    errorCode e;
  } v;
#ifdef DETECT_RESULT_LEAKS
  struct result *prev, *next;
#endif /* DETECT_RESULT_LEAKS */
} result;

#define resultDataType(rp)	(const objecttype )((rp)->dtype)

#define resultIsVoid(rp)	(datatypeResolve((rp)->dtype) == dtVoid)
#define resultIsBoolean(rp)	(datatypeResolve((rp)->dtype) == dtBoolean)
#define resultIsShort(rp)	(datatypeResolve((rp)->dtype) == dtShort)
#define resultIsInteger(rp)	(datatypeResolve((rp)->dtype) == dtInteger)
#define resultIsLong(rp)	(datatypeResolve((rp)->dtype) == dtLong)
#define resultIsFloat(rp)	(datatypeResolve((rp)->dtype) == dtFloat)
#define resultIsDouble(rp)	(datatypeResolve((rp)->dtype) == dtDouble)
#define resultIsList(rp)	(datatypeResolve((rp)->dtype) == dtList)
#define resultIsBlobPtr(rp)	(datatypeResolve((rp)->dtype) == dtBlob)
#define resultIsError(rp)	(datatypeResolve((rp)->dtype) == dtError)

#define resultSameType(r1, r2)	(r1->dtype == r2->dtype)

#define resultBoolean(rp)	(const bool )((rp)->v.b)
#define resultShort(rp)		(const short )((rp)->v.s)
#define resultInteger(rp)	(const int )((rp)->v.i)
#define resultLong(rp)		(const long )((rp)->v.l)
#define resultFloat(rp)		(const float )((rp)->v.f)
#define resultDouble(rp)	(const double )((rp)->v.d)
#define resultListPtr(rp)	(rp)->v.lp
#define resultBlobPtr(rp)	(rp)->v.bbp
#define resultError(rp)		(const errorCode )((rp)->v.e)

#define resultValue(rp)		\
  ((rp)->dtype == dtBoolean ? (rp)->v.b : \
   ((rp)->dtype == dtShort ? (rp)->v.s : \
    ((rp)->dtype == dtInteger ? (rp)-> v.i : \
     ((rp)->dtype == dtLong ? (rp)-> v.l : \
      ((rp)->dtype == dtFloat ? (rp)-> v.f : \
       ((rp)->dtype == dtDouble ? (rp)-> v.d : \
	((rp)->dtype == dtList ? (rp)-> v.lp : \
	 ((rp)->dtype == dtBlob ? (rp)-> v.bbp : \
	  ((rp)->dtype == dtError ? (rp)-> v.e : 0)

#define resultSetType(rp, dt)	(rp)->dtype = (dt)

#define resultSetVoid(rp)	(rp)->dtype = dtVoid
#define resultSetBoolean(rp, x)	((rp)->dtype = dtBoolean, (rp)->v.b = (x))
#define resultSetShort(rp, x)	((rp)->dtype = dtShort, (rp)->v.s = (x))
#define resultSetInteger(rp, x)	((rp)->dtype = dtInteger, (rp)->v.i = (x))
#define resultSetLong(rp, x)	((rp)->dtype = dtLong, (rp)->v.l = (x))
#define resultSetFloat(rp, x)	((rp)->dtype = dtFloat, (rp)->v.f = (x))
#define resultSetDouble(rp, x)	((rp)->dtype = dtDouble, (rp)->v.d = (x))
#define resultSetListPtr(rp, x)	((rp)->dtype = dtList, (rp)->v.lp = (x))
#define resultSetBlobPtr(rp, xbbp, xdt)	\
	((rp)->dtype = xdt, (rp)->v.bbp = (xbbp))
#define resultSetError(rp, x)	((rp)->dtype = dtError, (rp)->v.e = (x))

#define resultCount(rp, i)	(i ? 0 : 1)
#define resultDepth(rp, d)	(d)+1

result *resultCreate P((datatype type, ...));
result *resultCopy P((const result *rp));
int resultCompare P((const result *rp1, const result *rp2));
const result **resultNodePtr P((const result **rpp, int *count, int nodeNum,
				int internal, datatype *typeptr));
int resultToString P((const result *rp, charString *cstr));
void resultFree P((result *rp));
#ifdef DETECT_RESULT_LEAKS
int resultFoundLeak P((NOARGS));
#endif /* DETECT_RESULT_LEAKS */
#ifdef KEEP_ALLOCATED_MEMORY
void resultFreeStack P((NOARGS));
#endif /* KEEP_ALLOCATED_MEMORY */

#endif /* RESULT_H */
