#ifndef OBJECTLIST_H
#define OBJECTLIST_H

#include "compiler.h"
#include "genlist.h"
#include "charstring.h"

typedef genericList	objectList;

#include "object.h"

#define objectListCreate(len)	genericListCreate(sizeof(object *), len)
#define objectListCopy(olp)	genericListCopy(olp)
#define objectListLength(olp)	genericListLength(olp)
#define objectListEntry(olp, i)	*(object **)genericListEntry(olp, i)

int objectListAdd P((objectList *olp, void *ob));
int objectListOrganize P((objectList *olp));
int objectListCompare P((const objectList *olp1, const objectList *olp2));
struct object *objectListLookup P((const objectList *olp, const char *name,
				   unsigned len));
int objectListToString P((const objectList *olp, charString *cstr));
void objectListFree P((objectList *olp));

#endif /* OBJECTLIST_H */
