#ifndef INTERFACE_H
#define INTERFACE_H

#include "objectlist.h"
#include "program.h"

typedef void *(caseInitFunction) P((int));
typedef int (caseTerminateFunction) P((result *, void *, int));
typedef void (caseFitnessFunction) P((result *, int, int *, double *, double *,
				      void *));
typedef void (evalCleanupFunction) P((void *));
typedef int (terminateRunFunction) P((int, double, double));
typedef void (destroyFunction) P((NOARGS));

typedef struct interface {
  int cases;
  unsigned returntypes;
  objectList *tList, *fList;
  int current;
  void *environment;
  caseInitFunction *caseInit;
  caseTerminateFunction *caseTerminate;
  caseFitnessFunction *caseFitness;
  evalCleanupFunction *evalCleanup;
  terminateRunFunction *terminateRun;
  destroyFunction *destructor;
} interface;

typedef void (initializeFunction) P((interface *));

#define interfaceSetFitnessCases(ip, fc)	(ip)->cases = (fc)
#define interfaceSetTerminalList(ip, tl)	\
       objectListOrganize((ip)->tList = (tl))
#define interfaceSetFunctionList(ip, fl)	\
       objectListOrganize((ip)->fList = (fl))
#define interfaceSetReturnTypes(ip, dt)		(ip)->returntypes = (dt)

#define interfaceCaseInitializeFunc(ip, func)	(ip)->caseInit = (func)
#define interfaceCaseTerminateFunc(ip, func)	(ip)->caseTerminate = (func)
#define interfaceCaseFitnessFunc(ip, func)	(ip)->caseFitness = (func)
#define interfaceEvalCleanup(ip, func)		(ip)->evalCleanup = (func)
#define interfaceTerminateRunFunc(ip, func)	(ip)->terminateRun = (func)
#define interfaceDestructorFunc(ip, func)	(ip)->destructor = (func)

#define interfaceTerminalList(ip)	((const objectList *)(ip)->tList)
#define interfaceFunctionList(ip)	((const objectList *)(ip)->fList)
#define interfaceReturnTypes(ip)	((const unsigned )(ip)->returntypes)

#define interfaceCaseInitialize(ip, i)	(ip)->caseInit(i)
#define interfaceTerminateRun(ip, pp)					\
       ((ip)->terminateRun ?						\
	((ip)->terminateRun)(programHits(pp), programRawFitness(pp),	\
			     programStandardizedFitness(pp)) : 0)

interface *interfaceCreate P((initializeFunction *initFunc));
void interfaceEval P((const interface *ip, program *pp, int maxLoops,
		      double parsimony));
void interfaceFree P((interface *ip));

#endif /* INTERFACE_H */
