#ifndef CHARSTRING_H
#define CHARSTRING_H

#include "compiler.h"
#include <stdio.h>

typedef struct charString {
  char *buffer;
  int allocated, used;
} charString;

#define charStringBuffer(cstr)		((const char *)((cstr)->buffer))
#define charStringLength(cstr)		((const int )((cstr)->used))
#define charStringClear(cstr)		\
	((cstr)->used > 0 ? (cstr)->buffer[0] = (cstr)->used = 0 : 0)
#define charStringSet(cstr, s)		\
	charStringNSet(cstr, s, (int )strlen(s))
#define charStringCatenate(cstr, s)	\
	charStringNCatenate(cstr, s, (int )strlen(s))
#define charStringChop(cstr)		\
	((cstr)->used > 0 ? (cstr)->buffer[--((cstr)->used)] = 0 : 0)
					 
extern charString *charStringCreate P((NOARGS));
extern int charStringNSet P((charString *cstr, const char *text, int len));
extern int charStringNCatenate P((charString *cstr, const char *text,
				  int len));
extern int charStringRead P((charString *cstr, FILE *infile));
extern int charStringWrite P((const charString *cstr, FILE *outfile));
extern int charStringPrint P((const charString *cstr));
extern void charStringFree P((charString *cstr));

#endif /* CHARSTRING_H */
