/***** RCS INFO **********************************************************

$Id: tz_funcs.c,v 1.3 1992/10/16 17:03:43 whart Exp $
$Source: /a/odin/var/ftp/pub/GAbench/work/RCS/tz_funcs.c,v $
$Log: tz_funcs.c,v $
Revision 1.3  1992/10/16  17:03:43  whart
Updated to new format


****** RCS INFO *********************************************************/


/* tz_funcs.c
 *
 * Standard global optimization suite taken from Torn and Zilinskas
 * This set includes all of the functions in ds_funcs, though those
 * functions are not defined here.
 */

#include "optfunc.h"



/**************************************************************
 * Function definitions
 */

#include "tz_f1.c"
#include "tz_f2.c"
#include "tz_f3.c"
#include "tz_f4.c"
#include "tz_f5.c"


/**************************************************************
 * optfunc structure containing information about the functions
 */

nfuncs_t tz_funcs_nfuncs = 5;

funcset_t tz_funcs_optfuncs = {

FUNC( "Branin 1972 - six-hump camel-back [C]","\
  This function is symmetric about the origin and has three\n\
  conjugate pairs of local minima with values f_1 = -1.0316285,\n\
  f_2 = -0.2154 and f_3 = 2.1042.  The global minimum is attained\n\
  at (0.08983, -0.7126) and (-0.08983, 0.7126).",
    tz_f1, NULL, "[-5.0,5.0]^2", NULL, NULL),

FUNC( "Rastrigin 1974 [R]","\
  The optimum is equal to -2 and is located at the origin.  There are\n\
  about 50 local minima arranged in a lattice configuration about the origin.",
    tz_f2, NULL, "[-1.0,1.0]^2", NULL, NULL),

FUNC( "Strongin 1978 [St]","\
  This class of test functions simulate problems of mechanics.\n\
  Originally, these problems depended on two variables.  They may be\n\
  generalized to higher dimensions, but in this case the connection to\n\
  mechanics is lost.\n\
  Note: the description in TZ was a bit ambiguous.  Check out where x[0]\n\
	and x[1] are really used.",\
	tz_f3, NULL, "[-1.0,1.0]^2", NULL, NULL),

FUNC( "Griewank [G2]","\
  The function n=2, d=200 and x in [-100,100] has its global minimum\n\
  at f=0, x=0 and some 500 further minima in the region of interest.",
    tz_f4, tz_df4, "*[-100.0,100.0]^2", NULL, NULL),

FUNC( "Griewank [G10]","\
  The function n=10, d=4000, x in [-600,600] has its global minimum\n\
  at f=0, x=0 and several thousand local minima.",
    tz_f5, tz_df5, "*[-600.0,600.0]^10", NULL, NULL)

};


