#include <math.h>
#include "GAbench.h"
#include "_error.h"


#ifndef GRIEWANK
#define GRIEWANK

static REAL griewank(REAL* x, int n, REAL d)
{
REAL temp, ans=0.0;
int i;

for (i=0; i<n; i++)
  ans += x[i]*x[i];
ans /= d;

temp = -1.0;
for (i=0; i<n; i++)
  temp *= cos(x[i]/sqrt((double)i+1.0));

ans += temp + 1.0;

return ans;
}

static int      tmpvec_len=0;
static double   *tmpvec;

static int dgriewank(REAL* x, int n, REAL d, REAL* gradient)
{
int i,j;

/* Here we resize the vector if needed. */
if (tmpvec_len != n) {
   if (tmpvec_len != 0) {
      if (free((char*) tmpvec) == 0)
         return ERR;
      }
   if ((tmpvec=(REAL*)calloc((unsigned)n, (unsigned)sizeof(REAL))) == NULL)
      return(ERR);
   tmpvec_len = n;
   }

for (i=0; i<n; i++)
  tmpvec[i] = cos(x[i]/sqrt((double)i+1.0));

for (i=0; i<n; i++) {
  gradient[i] = 1.0;
  for (j=0; j<n; j++)
    if (i == j)
       gradient[i] *= tmpvec[i];
    else
       gradient[i] *= sin(x[i]/sqrt((double)i+1.0));
  gradient[i] /= sqrt((double)i+1.0);
  gradient[i] += 2.0*x[i]/d;
  }

return 0;
}
#endif


REAL tz_f5(REAL* x, int n)
{
return griewank(x, n, 4000.0);
}

int tz_df5(REAL* x, int n, REAL* gradient)
{
return dgriewank(x, n, 4000.0, gradient);
}


