/***** RCS INFO **********************************************************

$Id: st_funcs.c,v 1.3 1992/10/16 17:03:43 whart Exp $
$Source: /a/odin/var/ftp/pub/GAbench/work/RCS/st_funcs.c,v $
$Log: st_funcs.c,v $
Revision 1.3  1992/10/16  17:03:43  whart
Updated to new format


****** RCS INFO *********************************************************/

/* st_funcs.c
 *
 * Optimization suite taken from Styblinski and Tang
 */

#include "optfunc.h"


/**************************************************************
 * Function definitions
 */


#include "st_f1.c"
#include "st_f2.c"
#include "st_f3.c"
#include "st_f4.c"
#include "st_f5.c"

/**************************************************************
 * optfunc structure containing information about the functions
 */

nfuncs_t st_funcs_nfuncs = 5;

funcset_t st_funcs_optfuncs = {

FUNC("f1", "\
  Two dimensional function with four local minima with a global minimum\n\
  at x_i=-2.903534.  Function attributed to Szu, 1986.\n\
  This function is identical to f3, when n=2.",
	NULL, NULL, "[-10.0,10.0]^2", NULL, NULL),

FUNC("f2", "\
  Two dimensional function with a small number of local minima.\n\
  The global minimum is at x_i=-2.903534",
	st_func2, st_dfunc2, "[-10.0,10.0]^2", NULL, NULL),

FUNC("f3", "\
  Ten dimensional function with 2^10 local minima.  The global minimum\n\
  is at x_i=-2.903534, with a value of -78.3323.  The global maximum is\n\
  at x_i=10.0, with a value of 8450.",
	st_func3, st_dfunc3, "*[-10.0,10.0]^10", NULL, NULL),

FUNC("f4", "\
  Five dimensional function equivalent to f1, but with a quadratic added\n\
  to skew the minima along different dimensions.",
	st_func4, st_dfunc4, "[-10.0,10.0]^5", NULL, NULL),

FUNC("f5", "\
  Ten dimensional combination of a quadratic with a product of cosines.\n\
  This is very similar to Griewank's function",
	st_func5, st_dfunc5, "*[-10.0,10.0]^10", NULL, NULL)

};


