/**
 **
 ** F5
 **
 **/

#include <math.h>
#include "GAbench.h"
#include "_error.h"


static REAL st_func5(REAL* x, int n)
{
REAL ans=0.0, temp=1.0;
int i;

for (i=0; i<n; i++)
  temp *= cos(x[i]);
temp *= 4.0*n;

for (i=0; i<n; i++)
  ans += x[i]*x[i];

ans /= 2.0*n;

return(ans+temp);
}

static int st_dfunc5(REAL* x, int n, REAL* gradient)
{
static int      tmpvec_len=0;
static REAL   *tmpvec;
register int    i,j;

if (tmpvec_len != n) {                          /* resize tmpvec if needed */
   if (tmpvec_len != 0) {
      if (free((char*) tmpvec) == 0)
         return ERR;
      }
   if ((tmpvec=(REAL*)calloc((unsigned)n, (unsigned)sizeof(REAL))) == NULL)
      return(ERR);
   tmpvec_len = n;
   }

for (i=0; i<n; i++)
  tmpvec[i] = cos(x[i]);

for (i=0; i<n; i++) {
  gradient[i] = 1.0;
  for (j=0; j<n; j++)
    if (i == j)
       gradient[i] *= tmpvec[i];
    else
       gradient[i] *= sin(x[i]);
  gradient[i] *= 4.0*n;
  gradient[i] += x[i]/((double)n);
  }

return OK;
}


