/**
 **
 ** F2
 **
 **/

#include <math.h>
#include "GAbench.h"
#include "_error.h"

#define QUAD(x)         x*(x*(x*x - 16.0) + 5.0)
#define DQUAD(x)        x*(4.0*x*x - 32.0) + 5.0


static REAL st_func2(REAL* x, int n)
{
#ifdef ERR_CHECK
if (n != 2)   Erexit("st_func2 - must be dimension 2");
#endif

return( 0.5*(QUAD(x[0]) + QUAD(x[1]))
        - 10 * cos(4*(x[0] + 2.093534)) * cos(2*(x[1] + 2.903534)) );
}


static int st_dfunc2(REAL *x, int n, REAL *gradient)
{
gradient[0] = 0.5*DQUAD(x[0]) +
                10 * sin(4*(x[0] + 2.093534)) * 4 * cos(2*(x[1] + 2.903534));
gradient[1] = 0.5*DQUAD(x[1]) +
                10 * sin(2*(x[1] + 2.093534)) * 2 * cos(4*(x[0] + 2.903534));

return OK;
}
