
/* msb_funcs.c
 *
 * Standard global optimization suite taken from  Muhlenbein,
 * Schomisch and Born, ICGA '91.  This set includes all of the functions
 * in DeJong's test set, though those functions are not defined here.
 */

#include "optfunc.h"


/**************************************************************
 * Function definitions
 */


#include "msb_f6.c"

#include "msb_f7.c"

#include "msb_f8.c"


/**************************************************************
 * optfunc structure containing information about the functions
 */

nfuncs_t msb_funcs_nfuncs = 3;

funcset_t msb_funcs_optfuncs = {

FUNC( "Rastrigin [F6]","\
  Slightly modified version of Rastrigin's function.\n\
  The optimum is equal to 0 and is located at the origin.  There \n\
  local minima are arranged in a lattice configuration about the origin.\n\
  The maximum of the function is at x_i == 4.52299 where the function\n\
  is n(20.4574 + A*1.989585)",
    msb_f6, msb_df6, "*[-5.12,5.12]^20", NULL, NULL),

FUNC( "Schwefel [F7]","\
  The global minimum is at x_i = 420.9687.  The local minima are\n\
  located at points were x_k ~= (pi(0.5+k))^2, even k and\n\
  x_k -(pi(0.5+k))^2, odd k.  The second best minimum is at\n\
  x_i = 420.9687, x_j = -302.5232 (for any j).",
	msb_f7, NULL, "*[-500,500]^10", NULL, NULL),

FUNC( "Griewank [F8]","\
  This is Griewank's function in 10 dimensions, though it can be used\n\
  in an arbitrary number of dimensions.  The function uses d=4000,\n\
  has its global minimum at f=0, x=0 and several thousand local minima.",
	msb_f8, msb_df8, "*[-600.0,600.0]^10", NULL, NULL)

};
