
/*
 * M"uhlenbein's (ICGA'91) f8, attributed to Griewangk
 *
 * superposition of very flat parabola with product of sines
 *
 */

#include <math.h>
#include "GAbench.h"
#include "_error.h"

#ifdef __STDC__
REAL msb_f8(REAL* x, int n)
#else
REAL msb_f8(x,n)
REAL *x;
int n;
#endif
{
	register int i;
	register REAL sum = 0.0, pro = 1.0;

	for (i = 1; i <= n; i++, x++)
	{
		sum += *x * *x;
		pro *= cos(*x / sqrt((double) i));
	}
	return(sum/4000.0 - pro + 1.0);
}


#ifdef __STDC__
int msb_df8(REAL* x, int n, REAL* gradient)
#else
int msb_df8(x,n,gradient)
REAL *x, *gradient;
int n;
#endif
{
static int      tmpvec_len=0;
static REAL   *tmpvec;
register int 	i,j;    
       
if (tmpvec_len != n) {				/* resize tmpvec if needed */
   if (tmpvec_len != 0) {
      if (free((char*) tmpvec) == 0)
         return ERR;
      }
   if ((tmpvec=(REAL*)calloc((unsigned)n, (unsigned)sizeof(REAL))) == NULL)
      return(ERR);
   tmpvec_len = n;
   }        
            
for (i=0; i<n; i++)
  tmpvec[i] = cos(x[i]/sqrt((double)i+1.0));
            
for (i=0; i<n; i++) {
  gradient[i] = 1.0;
  for (j=0; j<n; j++)
    if (i == j)
       gradient[i] *= tmpvec[i];
    else    
       gradient[i] *= sin(x[i]/sqrt((double)i+1.0));
  gradient[i] /= sqrt((double)i+1.0);
  gradient[i] += 2.0*x[i]/4000.0;
  }         
            
return OK;
}       
