
/*
 * M"uhlenbein's (ICGA'91) f6, attributed to Rastrigin
 *
 * global minimum f6(0,0,0,...) = 0.0
 *
 */

#include <math.h>
#include "GAbench.h"
#include "_error.h"


#define A 10.0   /* apparently M"uhlenbein's value */

#ifdef __STDC__
REAL msb_f6(REAL* x, int n)
#else
REAL msb_f6(x,n)
REAL *x;
int n;
#endif
{
	register int i;
	register double sum;

	sum = n * A;
	for (i = 0; i < n; i++, x++)
		sum += *x * *x - A * cos(2 * M_PI * *x);
	return(sum);
}


#ifdef __STDC__
int msb_df6(REAL* x, int n, REAL* gradient)
#else
int msb_df6(x,n,gradient)
REAL *x, *gradient;
int n;
#endif
{
	register int i;

	for (i = 0; i < n; i++, x++, gradient++)
	    *gradient = 2.0 * *x + A * sin(2 * M_PI * *x) * 2 * M_PI;

	return(OK);
}
