/***** RCS INFO **********************************************************

$Id$
$Source$
$Log$

****** RCS INFO *********************************************************/


/* ds_funcs.c
 *
 * Standard global optimization suite taken from Dixon and Szeg\"{o}
 */

#include "optfunc.h"





/**************************************************************
 * Function definitions
 */

#include "ds_f1.c"
#include "ds_f2.c"
#include "ds_f3.c"
#include "ds_f4.c"
#include "ds_f5.c"
#include "ds_f6.c"
#include "ds_f7.c"



/**************************************************************
 * optfunc structure containing information about the functions
 */

nfuncs_t ds_funcs_nfuncs = 7;

funcset_t ds_funcs_optfuncs = {

FUNC("Shekel (SQRIN5) [S5]", "\
   The local minima with values approximately equal to -1/c_i are reached\n\
   at the points close to A(i)",
    ds_f1, NULL, "[0.0,10.0]^4", NULL, NULL),

FUNC("Shekel (SQRIN7) [S7]", "\
   The local minima with values approximately equal to -1/c_i are reached\n\
   at the points close to A(i)",
    ds_f2, NULL, "[0.0,10.0]^4", NULL, NULL),

FUNC("Shekel (SQRIN10) [S10]", "\
   The local minima with values approximately equal to -1/c_i are reached\n\
   at the points close to A(i)",
    ds_f3, NULL, "[0.0,10.0]^4", NULL, NULL),

FUNC("Hartman [H3]", "\
   The global minimum is equal to -3.86 and it is reached at the\n\
   point (0.114,0.556,0.852).",
    ds_f4, NULL, "[0.0,1.0]^3", NULL, NULL),
  
FUNC("Hartman [H6]", "\
   The global minimum is equal to -3.32 at the\n\
   point (0.021, 0.105, 0.477, 0.275, 0.311, 0.657).",
    ds_f5, NULL, "[0.0,1.0]^6", NULL, NULL),

FUNC("Branin & Hoo, 1972 (RCOS)[BR]", "\
   The global minimum is approximately 0.398 and is reached at three\n\
   points:  (-3.142,12.275), (3.142,2.275) and (9.425,2.425)",
    ds_f6, NULL, "[-5.0,10.0] [0.0,15.0]", NULL, NULL),

FUNC("Goldstein & Price (GOLDPR)[GP]", "\
   The global minimum is 3.0 and the minimal point it (0,-1).  There are\n\
   four local minima in the minimization region.",
    ds_f7, NULL, "[-2.0,2.0]^2", NULL, NULL)

};

