#include <math.h>
#include "GAbench.h"
#include "_error.h"


REAL ds_f6(REAL* x, int n)
{
REAL ans=0.0;

const REAL a=1.0;
const REAL b=5.1/(4.0*M_PI*M_PI);
const REAL c=5.0/M_PI;
const REAL d=6.0;
const REAL e=10.0;
const REAL f=1.0/(8.0*M_PI);

#ifdef ERR_CHECK
if (n != 2)  Erexit("ds_f6 - must be dimension 2");
#endif

ans = (x[1] + b*x[0]*x[0] + c * x[0] - d);
ans = ans*ans * a;
ans += e * (1.0-f) * cos((double) x[0]) + e;

return ans;
}


