#include "GAbench.h"
#include "_error.h"


#ifdef DS_HARTMAN
#define DS_HARTMAN
static REAL hartman_data[8][13] = {
        {3.0, 10.0, 30.0, 1.0, 0.3689, 0.1170, 0.2673},
        {0.1, 10.0, 35.0, 1.2, 0.4699, 0.4387, 0.7470},
        {3.0, 10.0, 30.0, 3.0, 0.1091, 0.8732, 0.5547},
        {0.1, 10.0, 35.0, 3.2, 0.03815, 0.5743, 0.8828},

        {10.0,  3.0, 17.0,  3.5,  1.7,  8.0, 1.0, 0.1312, 0.1696, 0.5569, 0.0124
, 0.8283, 0.5886},
        {0.05, 10.0, 17.0,  0.1,  8.0, 14.0, 1.2, 0.2329, 0.4135, 0.8307, 0.3736
, 0.1004, 0.9991},
        {3.0,   3.5,  1.7, 10.0, 17.0,  8.0, 3.0, 0.2348, 0.1451, 0.3522, 0.2883
, 0.3047, 0.6650},
        {17.0,  8.0,  0.05, 10.0, 0.1, 14.0, 3.2, 0.4047, 0.8828, 0.8732, 0.5743
, 0.1091, 0.0381}
        };

static REAL hartman(REAL* x, int dim)
{
int i,j,offset;
REAL temp, ans=0.0;

if (dim == 6)  offset = 4;
else offset = 0;

for (i=0; i<4; i++) {
  temp = 0.0;
  for (j=0; j<4; j++)
    temp += hartman_data[i+offset][j]*(x[j]-hartman_data[i+offset][j+dim+1])*
                        (x[j]-hartman_data[i+offset][j+dim+1]);
  ans += hartman_data[i+offset][dim] * exp((double) -1.0*temp);
  }

return (-1.0*ans);
}
#endif

REAL ds_f5(REAL* x, int n)
{
#ifdef ERR_CHECK
if (n != 6)  Erexit("ds_f5 - must be dimension 6");
#endif

return hartman(x,6);
}


