#include "GAbench.h"
#include "_error.h"


#ifndef DS_SQRIN
#define DS_SQRIN
static REAL sqrin_data[10][5] = {
                        {4.0, 4.0, 4.0, 4.0, 0.1},
                        {1.0, 1.0, 1.0, 1.0, 0.2},
                        {8.0, 8.0, 8.0, 8.0, 0.2},
                        {6.0, 6.0, 6.0, 6.0, 0.4},
                        {3.0, 7.0, 3.0, 7.0, 0.4},
                        {2.0, 9.0, 2.0, 9.0, 0.6},
                        {5.0, 5.0, 3.0, 3.0, 0.3},
                        {8.0, 1.0, 8.0, 1.0, 0.7},
                        {6.0, 2.0, 6.0, 2.0, 0.5},
                        {7.0, 3.6, 7.0, 3.6, 0.5}
                        };

static REAL sqrin(REAL* x, int m)
{
int i,j;
REAL temp, ans=0.0;

for (i=0; i<m; i++) {
  temp=0.0;
  for (j=0; j<4; j++)
    temp += (x[j]-sqrin_data[i][j]) * (x[j]-sqrin_data[i][j]);
  ans += 1.0/(temp + sqrin_data[i][4]);
  }

return( -1.0*ans);
}
#endif

REAL ds_f2(REAL* x, int n)  /* SQRIN7 */
{
#ifdef ERR_CHECK
if (n != 4)  Erexit("ds_f2 - must be dimension 4");
#endif

return(sqrin(x,7));
}
