/***** RCS INFO **********************************************************

$Id$
$Source$
$Log$

****** RCS INFO *********************************************************/


/* dejong_funcs.c
 *
 * Collection of Genetic Algorithm test functions developed by 
 * DeJong.  This collection was adapted from code included in GAucsd
 */

#include "optfunc.h"
#include "GAbench.h"



/**************************************************************
 * Function definitions 
 */

#include "dejong_f1.c"
#include "dejong_f2.c"
#include "dejong_f3.c"
#include "dejong_f4.c"
#include "dejong_f5.c"


/**************************************************************
 * optfunc structure containing information about the functions
 */

nfuncs_t dejong_funcs_nfuncs = 5;

funcset_t dejong_funcs_optfuncs = {

FUNC( "f1", "\
   Unique global minimum at x_i=0.0 for which the function is zero.",
        dejong_f1, dejong_df1, "*[-5.12,5.12]^3", NULL,NULL),
       
FUNC( "f2","\
   Unique global minimum at x_i=1.0 for which the function is zero.",
        dejong_f2, dejong_df2, "[-2.048,2.048]^2", NULL,NULL),
       
FUNC( "f3", "\
   Global minima are located at x for which integer(x_i)=-5.  The equation\n\
   in Goldberg '89 doesn't add 30.  With this addition, the minimum is zero.",
        dejong_f3, NULL, "*[-5.12,5.12]^5", NULL,NULL),
       
FUNC( "f4", "\
   This is a modified quadratic with noise.  Without the noise, the unique\n\
   minimum is at x_i=0 with a value of zero.",
        dejong_f4, NULL, "*[-1.28,1.28]^30", NULL,NULL),
       
FUNC( "f5", "\
   Unique global minimum at x=(-32,-32).  Total of 25 local minima with\n\
   coordinates of +/-32, +/-16, 0.",
        dejong_f5, dejong_df5, "[-65.536,65.536]^2", NULL,NULL)

};
