
/*
 * DeJong's f5
 *
 */

#include "GAbench.h"
#include "_error.h"

static int a[2][25] ={
	{
		-32, -16, 0, 16, 32, -32, -16, 0, 16, 32, -32, -16, 0, 16, 32,
		-32, -16, 0, 16, 32, -32, -16, 0, 16, 32	},
	{
		-32, -32, -32, -32, -32, -16, -16, -16, -16, -16, 
		16, 16, 16, 16, 16, 32, 32, 32, 32, 32	}
};


static int K = 500;


#ifdef __STDC__
REAL dejong_f5(REAL* x, int n)
#else   
REAL dejong_f5(x,n)
register REAL *x;
int n;  
#endif
{
	register int i, j;
    	register int N;
	REAL ans;
	REAL fj; 
	REAL prod;
	REAL diff;

	ans = 1.0/K;
	for (j = 0; j < 25; j++)
	{
		fj = j + 1;
		for (i = 0; i < 2; i++)
		{
			diff = x[i] - a[i][j];
			for (prod = 1, N = 0; N < 6; N++)
				prod *= diff;
			fj += prod;
		}
		ans += 1.0 / fj;
	}
	return(1.0 / ans);
}



#ifdef __STDC__
int dejong_df5(REAL *x, int n, REAL *grad)
#else
int dejong_df5(x, n, grad)
REAL *x, *grad;
int n;
#endif 
{
register int i, j;
register int N;  
REAL fj;
REAL prod0,prod1;
REAL diff;
REAL denom;

denom = dejong_func5(x,n);
denom *= denom;   

grad[0] = 0.0;  
grad[1] = 0.0;

for (j=0; j<25; j++) {
  fj = j+1;       
                  
  diff = x[0] - a[0][j];
  for ( prod0=1.0, N=0; N<5; N++)
    prod0 *= diff;
  fj += prod0*diff;
                  
  diff = x[1] - a[1][j];
  for ( prod1=1.0, N=0; N<5; N++)
    prod1 *= diff;
  fj += prod1*diff;
                  
  grad[0] += prod0/(fj*fj);
  grad[1] += prod1/(fj*fj);
  }               
                  
grad[0] *= 6.0/denom;
grad[1] *= 6.0/denom;
                  
return OK;         
}       
