
/*
 * M"uhlenbein's (ICGA'91) f6, attributed to Rastrigin
 *
 * global minimum f6(0,0,0,...) = 0.0
 *
 */

#include <math.h>

#define A 10.0   /* apparently M"uhlenbein's value */

double f6(x)
register double *x;
{
	register int i;
	register double sum;

	sum = 20 * A;
	for (i = 0; i < 20; i++, x++)
		sum += *x * *x - A * cos(2 * M_PI * *x);
	return(sum);
}

