/* pga.h
 * Copyright (C) 1993 Peter Ross and Geoff Ballinger.
 * This is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License, see the file COPYING.
 *
 * Mainly locations for use in PGA screen layout. But see last defines.
 */

/* Populations: */
#define POP_ROW       1
#define POP_COL       1

/* Chromosomes per population: */
#define CPP_ROW       1
#define CPP_COL       35

/* ....Chromosome length: */
#define CRL_ROW       2
#define CRL_COL       39

/* Number of evaluations: */
#define EVLIM_ROW     3
#define EVLIM_COL     1

/* ...Reporting interval: */
#define REPINT_ROW    4
#define REPINT_COL    1

/* ...Migration interval: */
#define MIG_ROW       5
#define MIG_COL       1

/* .Reproduction: */
#define REPRO_ROW     3
#define REPRO_COL     43

/* ...Crossover type: */
#define CTYPE_ROW     4
#define CTYPE_COL     39

/* ...Crossover rate: */
#define CROSS_ROW     5
#define CROSS_COL     39

/* ....Mutation rate: */
#define MUT_ROW       6
#define MUT_COL       39

/* ....Log file name: */
#define FNAME_ROW     7
#define FNAME_COL     39

/* Eval function: */
#define EVAL_ROW      6 
#define EVAL_COL      9

/* ....Selection: */
#define SELECT_ROW    7
#define SELECT_COL    9

/* ...Selection bias: */
#define BIAS_ROW      8
#define BIAS_COL      5

/* Generation: */
#define GEN_ROW       8
#define GEN_COL       46

/* Evaluations so far: */
#define EVCOUNT_ROW   9
#define EVCOUNT_COL   38

/* The population table */
#define POPTABLE_ROW  10
#define POPTABLE_COL  14


/* If a genotype is longer than this (set by -n) then use
   a double in the decode routine, because a long will overflow.
   A long is 32 bits on most systems, so a value of 60 assumes
   that every call of decode() will be trying to split the
   genotype into at least two numbers, so won't be collecting
   up more than 30 bits at one go. */
#define CRUCIAL_GENO_SIZE 60

/* Actions possible */

#define QUIT      1
#define CONTINUE  2
#define RESTART   3
#define ASK_AGAIN 4

