#include "genocop.h"
#if DOS_SYS
  extern FILE *input,*output;
#endif

/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   nrerror()                                    */
/*                                                                              */
/*           SYNOPSIS          :   void nrerror(error_text)                     */
/*                                                                              */
/*           DESCRIPTION       :   This function gives out an error message on  */
/*                                  to the standard output.                     */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   vector()                                     */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/



void nrerror(error_text)
char error_text[];
{
        fprintf(output,"Numerical Recipes run-time error...\n");
        fprintf(output,"%s\n",error_text);
        fprintf(output,"...now exiting to system...\n");
        exit(1);
}


/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   vector()                                     */
/*                                                                              */
/*           SYNOPSIS          :   float *vector(nl,nh)                         */
/*                                                                              */
/*           DESCRIPTION       :   This function returns a single dimensional   */
/*                                  float array after allocating memory from    */
/*                                  indices nl to nh                            */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   find_org_in_eq(),                            */
/*                                 initialize_x2(),                             */
/*                                 oper1(),                                     */
/*                                 oper2(),                                     */
/*                                 oper3(),                                     */
/*                                 optimization(),                              */
/*                                 main().                                      */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/



VECTOR vector(nl,nh)
int nl,nh;
{
        VECTOR v;

        if (nh <  nl)
          return(NULL);

        v=(float *)malloc((unsigned) (nh-nl+1)*sizeof(float));
        if (!v) nrerror("allocation failure in vector()");
        return v-nl;
}

/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   ivector()                                    */
/*                                                                              */
/*           SYNOPSIS          :   int *vector(nl,nh)                           */
/*                                                                              */
/*           DESCRIPTION       :   This function returns a single dimensional   */
/*                                  integer array after allocating memory from  */
/*                                  indices nl to nh                            */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   find_probability(),                          */
/*                                 initialize_x2(),                             */
/*                                 main(),                                      */
/*                                 optimization(),                              */
/*                                 p_equalities().                              */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/



IVECTOR ivector(nl,nh)
int nl,nh;
{
        IVECTOR v;

        if (nh <  nl)
          return(NULL);

        v=(int *)malloc((unsigned) (nh-nl+1)*sizeof(int));
        if (!v) nrerror("allocation failure in ivector()");
        return v-nl;
}


/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   matrix()                                     */
/*                                                                              */
/*           SYNOPSIS          :   float *matrix(nrl,nrh,ncl,nch)               */
/*                                                                              */
/*           DESCRIPTION       :   This function returns a two dimensional      */
/*                                  float array after allocating memory for the */
/*                                  rows from indices nrl to nrh, and for the   */
/*                                  columns from ncl to nch                     */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   det(),                                       */
/*                                 find_org_in_eq(),                            */
/*                                 initialize_x2(),                             */
/*                                 inverse(),                                   */
/*                                 main(),                                      */
/*                                 oper4(),                                     */
/*                                 oper5(),                                     */
/*                                 optimization(),                              */
/*                                 p_equalities().                              */
/*                                                                              */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/



MATRIX matrix(nrl,nrh,ncl,nch)
int nrl,nrh,ncl,nch;
{
        int i;
        MATRIX m;

        if (nrh <  nrl)
          return(NULL);
        if (nch <  ncl)
          return(NULL);

        m=(float **) malloc((unsigned) (nrh-nrl+1)*sizeof(float*));
        if (!m) nrerror("allocation failure 1 in matrix()");
        m -= nrl;

        for(i=nrl;i<=nrh;i++) {
                m[i]=(float *) malloc((unsigned) (nch-ncl+1)*sizeof(float));
                if (!m[i]) nrerror("allocation failure 2 in matrix()");
                m[i] -= ncl;
        }
        return m;
}


/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   imatrix()                                    */
/*                                                                              */
/*           SYNOPSIS          :   int *imatrix(nrl,nrh,ncl,nch)                */
/*                                                                              */
/*           DESCRIPTION       :   This function returns a two dimensional      */
/*                                  integer array after allocating memory for   */
/*                                  the rows from indices nrl to nrh, and for   */
/*                                  the columns from ncl to nch
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   find_probability(),                          */
/*                                 p_equalities().                              */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/



IMATRIX imatrix(nrl,nrh,ncl,nch)
int nrl,nrh,ncl,nch;
{
        int i;
        IMATRIX m;

        if (nrh <  nrl)
          return(NULL);
        if (nch <  ncl)
          return(NULL);

        m=(int **)malloc((unsigned) (nrh-nrl+1)*sizeof(int*));
        if (!m) nrerror("allocation failure 1 in imatrix()");
        m -= nrl;

        for(i=nrl;i<=nrh;i++) {
                m[i]=(int *)malloc((unsigned) (nch-ncl+1)*sizeof(int));
                if (!m[i]) nrerror("allocation failure 2 in imatrix()");
                m[i] -= ncl;
        }
        return m;
}

void free_vector(v,nl)
     float *v;
     int nl;
{
     if (v == NULL)
      return;
     else
      free((float*) (v+nl));
}

void free_ivector(v,nl)
     int *v,nl;
{
     if (v == NULL)
      return;
     else
      free((unsigned int*) (v+nl));
}
void free_matrix(m,nrl,nrh,ncl)
     float **m;
     int nrl,nrh,ncl;
{
     int i;

     if (m == NULL)
      return;
     else
      {
        for(i=nrh;i>=nrl;i--) free((float*) (m[i]+ncl));
          free((float*) (m+nrl));
      }
}
void free_imatrix(m,nrl,nrh,ncl)
     int **m;
     int nrl,nrh,ncl;
{
     int i;

     if (m == NULL)
      return;
     else
      {
        for(i=nrh;i>=nrl;i--) free((unsigned int*) (m[i]+ncl));
          free((unsigned int*) (m+nrl));
      }
}

