#include "genocop.h"

/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   find_probability()                           */
/*                                                                              */
/*           SYNOPSIS          :   void find_probability(p,tot,cart,prob)       */
/*                                                                              */
/*           DESCRIPTION       :   This function gives all possible 'p'         */
/*                                  combinations, from a total of 'tot'.        */
/*                                                                              */
/*           FUNCTIONS CALLED  :   bi_deci(),                                   */
/*                                 imatrix(),                                   */
/*                                 ivector(),                                   */
/*                                 x_power_y().                                 */
/*                                                                              */
/*           CALLING FUNCITONS :   p_equalities()                               */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/




void find_probability(p,tot,cart,prob)
int p,              /*number of combinations needed*/
    tot,            /*total number of original elements*/
    cart;           /*total number of 'p' out of 'tot' combinations available*/
IMATRIX prob;     /*array of all possible combinations*/
{
  int i,j,          /*counter variables*/
      mask,ans,v,
      pow2,         /*length of binary string needed to represent 'tot'*/
      arr_tot = 1,  /*index variable for the array*/
      t1,t2;        /*variables needed for the binary conversion*/

IVECTOR arr;        /*temporary array to contrain the binary string*/

IMATRIX crossprod;  /*binary representation of integers from 0 to 'cart'*/

  crossprod = imatrix(1,cart,1,tot);
  pow2 = x_power_y(2,tot);
  arr = ivector(1,tot+1);

  t1 = tot-1;
  t2 = tot;

  for(j=0; j < pow2; j++)
    {
      v = j;
      mask = 1;
      mask <<= t1;

      for(i=1; i<=t2; ++i)
        {
          ans = (((v & mask) == 0) ? '0' : '1');
          arr[i] = ans - 48;
          v <<= 1;
        }
      if(find_sum(arr,t2) == p)
        {
          for(i=1; i<=t2; ++i)
            crossprod[arr_tot][i] = arr[i];
          arr_tot++;
        }
    }
  bi_deci(crossprod,prob,cart,tot);/*binary to decimal conversion, representing*/
                                   /*the index of the array*/
  free_imatrix(crossprod,1,cart,1);
  free_ivector(arr,1);

}

/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   x_power_y()                                  */
/*                                                                              */
/*           SYNOPSIS          :   int x_power_y(x,y)                           */
/*                                                                              */
/*           DESCRIPTION       :   This function returns the value of 'x' to the*/
/*                                  power of 'y'.                               */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   find_probability()                           */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/




int x_power_y(x,y)
int x,y;
{
  int tot = 1,i;

  for(i=0; i < y; i++)
    tot = tot * x;
  return(tot);
}

/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   find_sum()                                   */
/*                                                                              */
/*           SYNOPSIS          :   int find_sum(arr,tot)                        */
/*                                                                              */
/*           DESCRIPTION       :   This function returns the sum of all the     */
/*                                  elements in a given integer array           */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   find_probability()                           */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/




int find_sum(arr,tot)
int tot;
IVECTOR arr;
{
  int i,sum = 0;

  for(i=1; i<=tot; i++)
    sum = sum + arr[i];

  return(sum);
}

