#include "thesis.h"

void oper1(parent,fin_mat,rc)
VECTOR parent;  
MATRIX fin_mat; 
INDEX rc;       
{
  int comp,i;
  float llim,ulim;

  comp = irange_ran(1,rc.c-2);

  find_range(&llim,&ulim,comp,fin_mat,rc,parent);

  parent[comp] = frange_ran(llim,ulim);
}


void oper2(parent,fin_mat,rc)
VECTOR parent;  
MATRIX fin_mat; 
INDEX rc;       
{
  int comp,i;
  float llim,ulim;

  comp = irange_ran(1,rc.c-2);

  find_range(&llim,&ulim,comp,fin_mat,rc,parent);

  parent[comp] = (flip() == TAIL) ? llim : ulim;
}

void oper3(parent,fin_mat,rc,T,t,B)
VECTOR parent;
MATRIX fin_mat;
INDEX rc;
int B,
    T,              
    t;              
{
  int comp,i;
  float llim,ulim;

  comp = irange_ran(1,rc.c-2);
  find_range(&llim,&ulim,comp,fin_mat,rc,parent);

  parent[comp] = (flip() == TAIL) ? parent[comp]-get_F(T,t,parent[comp]-llim,B) : 
                                     parent[comp]+get_F(T,t,ulim-parent[comp],B);
}


void oper4(p1,p2,A,x2_vari)
VECTOR p1,p2;  
int x2_vari;   
float A;       
{
  MATRIX child;
  int i;

  child = matrix(1,2,1,x2_vari);

  for(i=1; i<=x2_vari; i++)
    {
      child[1][i] = p1[i] * A + p2[i] * (1.0-A);
      child[2][i] = p2[i] * A + p1[i] * (1.0-A);
    }
  for(i=1; i<=x2_vari; i++)
    {
      p1[i] = child[1][i];
      p2[i] = child[2][i];
    }

  free_matrix(child,1,2,1,x2_vari);
}


void oper5(p1,p2,STEP,rc,fin_mat)
VECTOR p1,p2;   
INDEX rc;       
MATRIX fin_mat; 
int    STEP;    
{
  MATRIX child;
  FLAG _CHECK1 = FALSE,
       _CHECK2 = FALSE;
  int i,n=1,cut;

  child = matrix(1,2,1,rc.c-2);

  cut = irange_ran(1,rc.c-2);

  for(i=1; i<=cut; i++)
    {
      child[1][i] = p1[i];
      child[2][i] = p2[i];
    }      
  do
    {

      for(i=cut + 1; i<=rc.c-2; i++)
	{
	  child[1][i] = p1[i] * (float)n/(float)STEP + p2[i] * (1.0-(float)n/(float)STEP);
	  child[2][i] = p2[i] * (float)n/(float)STEP + p1[i] * (1.0-(float)n/(float)STEP);
	}

      _CHECK1 = satis_con(child[1],fin_mat,rc);
      _CHECK2 = satis_con(child[2],fin_mat,rc);
      n++;

   }while((n<=STEP) && ((_CHECK1 == FALSE) || (_CHECK2 == FALSE)));

  for(i=1; i<=rc.c-2; i++)
    {
      p1[i] = child[1][i];
      p2[i] = child[2][i];
    }
  free_matrix(child,1,2,1,rc.c-2);
}



void oper6(parent,fin_mat,rc,T,t,B)
VECTOR parent;
MATRIX fin_mat;
INDEX rc;
int B,
    T,         
    t;         
{
  int comp,i;
  float llim,ulim;

  for (comp=1; comp<=rc.c-2; comp++)
    {
  find_range(&llim,&ulim,comp,fin_mat,rc,parent);

  parent[comp] = (flip() == TAIL) ? parent[comp]-get_F(T,t,parent[comp]-llim,B) : 
                                     parent[comp]+get_F(T,t,ulim-parent[comp],B);
    }
}

FLAG satis_con(child,fin_mat,rc)
VECTOR child;   
MATRIX fin_mat; 
INDEX rc;       
{
  int i,j;
  float tot;


  for(j=1; j<=rc.c-2; j++)
    if((child[j] > fin_mat[j][rc.c]) || (child[j] < fin_mat[j][1]))
      return(FALSE);

  for(j=1; j<=rc.r; j++)
    {
      tot = 0.0;
      for(i=2; i<=rc.c-1; i++)
	tot = tot + fin_mat[j][i] * child[i-1];


      if((tot < fin_mat[j][1]) || (tot > fin_mat[j][rc.c]))
	return(FALSE);
    } 

  return(TRUE);
}


float get_F(T,t,y,B)
int t,B,T;
float y;
{
return(y*(1.0-pow(frange_ran(0.0,1.0),pow(1.0-(float)t/(float)T,(float)B))));
}


void find_range(llim,ulim,comp,fin_mat,rc,parent)
float *llim,*ulim;
int comp;         
INDEX rc;         
MATRIX fin_mat;   
VECTOR parent;    
{
  int i,j;
  float tot,templ,tempu,temp;
  FLAG _CHANGE=FALSE;

  for(j=1; j<=rc.r; j++)
    if(fin_mat[j][comp+1] != 0.0)
      {
	tot = 0.0;
	for(i=2; i<=rc.c-1; i++)
	  if(i!=comp+1)
	    tot = tot + fin_mat[j][i] * parent[i-1];

	templ = (fin_mat[j][1] - tot) / fin_mat[j][comp+1];
	tempu = (fin_mat[j][rc.c] - tot) / fin_mat[j][comp+1];

	if(fin_mat[j][comp+1]<0)
	  swap(&templ,&tempu);


	if(!_CHANGE)
	  {
	    *llim = templ;
	    *ulim = tempu;
	    _CHANGE = TRUE;
	  }
	else
	  {
	    if(*llim < templ)
	      *llim = templ;
	    if(*ulim > tempu)
	      *ulim = tempu;
	  }
      }
}	  

int irange_ran(llim,ulim)
int ulim,llim;
{
  int num; 
  if(ulim == 0)
    {
      printf("Divide by zero in irange_ran()\n");
      exit(1);
    }

  if(llim == ulim)
    return(llim);
  do
    {
      num = llim + rand() % ulim;
    }while((num < llim)||(num > ulim));
  return(num);
}

