#include "thesis.h"

void main(argc,argv)
int argc;
char *argv[];
{
  MATRIX equalities,   
         inequalities, 
         domains,      
         a1,           
         a2,
         inv_a1,       
         c1,           
         c2,
         new_in_eq,    
         org_ineq,     
         final_mat,    
         inva1_a2;     

  VECTOR inva1_b,      
         eq_rhs,       
         ineq_rhs,     
         ldomain,      
         udomain,      
         l1,           
         l2,           
         u1,
         u2,
         X;            

  IMATRIX var_order;   

  IVECTOR eq_co,       
          ineq_co,     
          x1,          
          x2,
          cart;        

  FLAG _PROGEND;       

  INDEX fin,           
        newin,         
        a1a2;          

  int cart_count = 0,  
      tot_combi,       
      i,               
      org_col,         
      tot_var,         
      tot_equ,         
      tot_ine,         
      tot_dom,         
      x2_vari,         
      tot_arr[4];      
                       

  seed();

  
  input = fopen(argv[1],"r");
  if(input == NULL)
    {
      printf("Open of %s for input failed",argv[1]);
      exit(1);
    }
  output = fopen(argv[2],"w");
    if(output == NULL)
    {
      printf("Open of %s for input failed",argv[2]);
      exit(1);
    }

  fscanf(input," %d",&tot_arr[0]);
  fscanf(input," %d",&tot_arr[1]);
  fscanf(input," %d",&tot_arr[2]);
  fscanf(input," %d",&tot_arr[3]);

  fin.r = tot_arr[2]+tot_arr[0];  
  fin.c = tot_arr[0]-tot_arr[1]+2;
  org_col = tot_arr[0]-tot_arr[1]+1;
  tot_var = tot_arr[0];             
  tot_equ = tot_arr[1];             
  tot_ine = tot_arr[2];             
  tot_dom = tot_arr[3];             
  x2_vari = tot_arr[0] - tot_arr[1];
  newin.r = tot_equ;
  newin.c = fin.c;
  a1a2.r = tot_equ;
  a1a2.c = org_col;

  final_mat = matrix(1,fin.r,1,fin.c);

  equalities = matrix(1,tot_equ,1,tot_var+1);
  eq_co = ivector(1,tot_var);
  eq_rhs = vector(1,tot_equ);
  a1 = matrix(1,tot_equ,1,tot_equ);
  a2 = matrix(1,tot_equ,1,x2_vari);
  inv_a1 = matrix(1,tot_equ,1,tot_equ);
  inva1_a2 = matrix(1,tot_equ,1,x2_vari);
  inva1_b = vector(1,tot_equ);
  new_in_eq = matrix(1,tot_equ,1,fin.c);

  inequalities = matrix(1,tot_ine,1,tot_var+1);
  ineq_co = ivector(1,tot_var);
  ineq_rhs = vector(1,tot_ine);
  c1 = matrix(1,tot_ine,1,tot_equ);
  c2 = matrix(1,tot_ine,1,x2_vari);
  org_ineq = matrix(1,tot_ine,1,org_col);

  domains = matrix(1,tot_var,1,3);
  ldomain = vector(1,tot_var);
  udomain = vector(1,tot_var);
  l1 = vector(1,tot_equ);
  l2 = vector(1,x2_vari);
  u1 = vector(1,tot_equ);
  u2 = vector(1,x2_vari);

  X = vector(1,tot_var);
  x1 = ivector(1,tot_equ);
  x2 = ivector(1,x2_vari);
  var_order = imatrix(1,tot_var,1,2);
  cart = ivector(1,tot_equ);

  read_file(equalities,inequalities,domains,tot_arr);

  for(i=1; i<=tot_var; i++)
    {
      eq_co[i] = i;
      ineq_co[i] = i;
    }
  for(i=1; i<=tot_equ; i++)
    eq_rhs[i] = equalities[i][tot_var+1];
   for(i=1; i<=tot_ine; i++)
    ineq_rhs[i] = inequalities[i][tot_var+1];

  print_equalities(equalities,tot_var,tot_equ,eq_co,eq_rhs);
  print_inequalities(inequalities,tot_var,tot_ine,ineq_co,ineq_rhs);
  print_domains(domains,tot_var);


  free_ivector(eq_co,1,tot_var);
  free_ivector(ineq_co,1,tot_var);




  do
    {
      if(tot_equ != 0)
	{

	  cart_count = p_equalities(equalities,tot_arr,cart,cart_count+1,&tot_combi);
      

	  get_var_order(tot_arr,cart,var_order);
      

	  find_x1_x2(tot_var,var_order,x1,x2);
      

	  find_ac1_ac2(tot_equ,tot_equ,x2_vari,x1,x2,equalities,a1,a2); 
      

	  inverse(a1,inv_a1,tot_equ);
      

	  mmprod(tot_equ,tot_equ,x2_vari,inva1_a2,inv_a1,a2);
      

	  mvprod(tot_equ,tot_equ,inva1_b,inv_a1,eq_rhs);
      

	  find_ac1_ac2(tot_equ,tot_ine,x2_vari,x1,x2,inequalities,c1,c2);
      

	  find_limits(tot_var,domains,ldomain,udomain);
      

	  find_lu1_lu2(tot_arr,x1,x2,ldomain,l1,l2);
	  find_lu1_lu2(tot_arr,x1,x2,udomain,u1,u2);
      

	  find_new_in_eq(inva1_b,inva1_a2,l1,u1,newin,new_in_eq);
      

	  find_org_in_eq(inva1_b,inva1_a2,ineq_rhs,c1,c2,tot_ine,a1a2,org_ineq);
      

	  initialize(final_mat,fin);
	  

	  find_final_mat1(x2,l2,u2,final_mat,x2_vari,fin.c);
	  find_final_mat2(new_in_eq,tot_equ,fin.c,org_col,final_mat);
	  find_final_mat3(org_ineq,tot_ine,org_col,tot_var+1,final_mat);
	}
      else
	{
	  for (i=1; i<=tot_var; i++)
	    {
	      l2[i] = domains[i][1];
	      x2[i] = domains[i][2];
	      u2[i] = domains[i][3];
	    }
	  initialize(final_mat,fin);
	  find_final_mat1(x2,l2,u2,final_mat,tot_var,fin.c);

	  if(tot_ine != 0)
	    find_final_mat3(inequalities,tot_ine,org_col,tot_var+1,final_mat);
	}

      _PROGEND = initialize_x2(final_mat,fin,x1,x2,tot_equ,X,inva1_b);
    }while((!_PROGEND)&&(cart_count < tot_combi));

  free_vector(eq_rhs,1,tot_equ);
  free_vector(ineq_rhs,1,tot_ine);
  free_vector(ldomain,1,tot_var);
  free_vector(udomain,1,tot_var);
  free_vector(l1,1,tot_var);
  free_vector(l2,1,x2_vari);
  free_vector(u1,1,tot_equ);
  free_vector(u2,1,x2_vari);
  free_ivector(cart,1,tot_equ);



  if(tot_equ != 0)
    {
      if(cart_count >= tot_combi)
	{
	  fprintf(output,"Incorrect data");
	  exit(1);
	}
      
      optimization(X,x1,x2,final_mat,fin,tot_equ,inva1_b);
    }
  else
    optimization(X,x2,x2,final_mat,fin,tot_equ,inva1_b);
  fclose(output);
}


