#include "thesis.h"
void optimization(X,x1,x2,fin_mat,rc,tot_eq,a1_b)
MATRIX fin_mat;
VECTOR X,a1_b;
IVECTOR x1,x2;
INDEX rc;
int tot_eq;
{
  MATRIX new_genera,   
         population,   
         print_pop,
         temp;

  VECTOR probab,       
         cum_probab,   
         t_vec,
         eval;

  IVECTOR live,
          die;

     
  int pop_size,             
      generations,          
      count_gener= 1,       
      NGcount=1,            
      MinMax,               
      P,                    
      P1,                   
      P2,
      P3,
      P4,
      P5,
      P6,
      B,                    
      STEP,                 
      x2_vari = rc.c-2,
      first,                
      second,
      tot,                  
      i,
      j,
      k;

  float Q,                  
        A,                  
        Teval;              

  fscanf(input,"%d %d %d %d %d %d %d %d ",&pop_size,&generations,&P1,&P2,&P3,&P4,&P5, &P6);
  fscanf(input,"%f ",&Q);
  fscanf(input,"%d ",&MinMax);
  fscanf(input,"%d ",&B);
  fscanf(input,"%f ",&A);
  fscanf(input,"%d ",&STEP);
  fclose(input);

  fprintf(output,"\n\nValues for operators: %d  %d  %d  %d  %d  %d\n", P1, P2, P3, P4, P5, P6);
  fprintf(output,"\nOther parameters: Pop-size = %d\n                  Generations = %d\n                  B = %d\n                  A = %f\n", pop_size,generations,B,A);

  P = P1 + P2 + P3 + P4 + P5 + P6;
  if(P > pop_size)
    {
      fprintf(output,"The total number of operators greater than population");
      fclose(output);
      exit(1);
    }
	
  population = matrix(1,pop_size,1,x2_vari);
  print_pop = matrix(1,pop_size,1,x2_vari+tot_eq);
  new_genera = matrix(1,pop_size,1,x2_vari+1);
  temp = matrix(1,2,1,x2_vari);
  probab = vector(1,pop_size);
  t_vec = vector(1,x2_vari);
  cum_probab = vector(1,pop_size);
  eval = vector(1,pop_size);
  live = ivector(1,pop_size);
  die = ivector(1,pop_size);



  for(i=1; i<=x2_vari; i++)
    for(j=1; j<=pop_size; j++)
      population[j][i] = X[x2[i]];

  fprintf(output,"\nThe initial point of the population is\n");
  print_vector(X,1,tot_eq+x2_vari);
  fprintf(output,"\n\n");


  eval[1] = evaluate(X);
  for(j=2; j<=pop_size; j++)
    eval[j] = eval[1];

  fprintf(output,"\nThe value of the initial point is  %f\n", eval[1]);
  fprintf(output,"\n\n");

  assign_probab(probab,pop_size,Q);

  find_cum_probab(cum_probab,probab,pop_size);

  Teval = eval[1];

  do
    {
      for(j=1; j<=pop_size; j++)
	{
	  live[j] = die[j] = 0;
	  new_genera[j][1] = 0.0;
	  for(i=1; i<=x2_vari + 1; i++)
	    new_genera[j][i+1] = population[j][i];
	}


      find_live_die(cum_probab,live,die,pop_size,P);


      for(j=1; j<=P1; j++)
	{
	  first = find_parent(live,pop_size);
	  new_genera[first][1] = 1.0;
	  for(i=1; i<=x2_vari; i++)
	    t_vec[i] = new_genera[first][i+1];
	  oper1(t_vec,fin_mat,rc);
	  for(i=1; i<=x2_vari; i++)
	    new_genera[first][i+1] = t_vec[i];
	}

      for(j=1; j<=P2; j++)
	{
	  first = find_parent(live,pop_size);
	  new_genera[first][1] = 1.0;
	  for(i=1; i<=x2_vari; i++)
	    t_vec[i] = new_genera[first][i+1];
	  oper2(t_vec,fin_mat,rc);
	  for(i=1; i<=x2_vari; i++)
	    new_genera[first][i+1] = t_vec[i];
	}


      for(j=1; j<=P3; j++)
	{
	  first = find_parent(live,pop_size);
	  new_genera[first][1] = 1.0;
	  for(i=1; i<=x2_vari; i++)
	    t_vec[i] = new_genera[first][i+1];
	  oper3(t_vec,fin_mat,rc,generations,count_gener,B);
	  for(i=1; i<=x2_vari; i++)
	    new_genera[first][i+1] = t_vec[i];
	}
      
      for(j=1; j<=(int) P4/2; j++)
	{

	  first = find_parent(live,pop_size);
	  second = find_parent(live,pop_size);
	  new_genera[first][1] = 1.0;
	  new_genera[second][1] = 1.0;
	  for(i=1; i<=x2_vari; i++)
	    {
	      temp[1][i] = new_genera[first][i+1];
	      temp[2][i] = new_genera[second][i+1];
	    }	      
	  oper4(temp[1],temp[2],A,x2_vari);
	  for(i=1; i<=x2_vari; i++)
	    {
	      new_genera[first][i+1] = temp[1][i];
	      new_genera[second][i+1] = temp[2][i];
	    }
	}

      for(j=1; j<=(int) P5/2; j++)
	{

	  first = find_parent(live,pop_size);
	  second = find_parent(live,pop_size);
	  new_genera[first][1] = 1.0;
	  new_genera[second][1] = 1.0;
	  for(i=1; i<=x2_vari; i++)
	    {
	      temp[1][i] = new_genera[first][i+1];
	      temp[2][i] = new_genera[second][i+1];
	    }	      
	  oper5(temp[1],temp[2],STEP,rc,fin_mat);
	  for(i=1; i<=x2_vari; i++)
	    {
	      new_genera[first][i+1] = temp[1][i];
	      new_genera[second][i+1] = temp[2][i];
	    }
	}

      for(j=1; j<=P6; j++)
	{
	  first = find_parent(live,pop_size);
	  new_genera[first][1] = 1.0;
	  for(i=1; i<=x2_vari; i++)
	    t_vec[i] = new_genera[first][i+1];
	  oper6(t_vec,fin_mat,rc,generations,count_gener,B);
	  for(i=1; i<=x2_vari; i++)
	    new_genera[first][i+1] = t_vec[i];
	}
      

      k = 1;
      for(i=1; i<=pop_size; i++)
	if(die[i] != 0)
	  {
	    while(new_genera[k][1] != 1.0)
	      k++;
	    for(j=1; j<=x2_vari; j++)
	      population[i][j] = new_genera[k][j+1];
	    k++;
	  }
      

      for(i=1; i<=pop_size; i++)
	{
          if(tot_eq != 0)
	    {
	  for(j=1; j<=x2_vari + tot_eq; j++)
	    X[j] = 0.0;

	  find_X(fin_mat,population[i],X,x2_vari,tot_eq,x1,x2,a1_b);
	  for(j=1; j<=x2_vari + tot_eq; j++)
	    print_pop[i][j] = X[j];
	}
	           else
            for(j=1; j<=x2_vari; j++)
              print_pop[i][j] = X[j] = population[i][j];

          eval[i] = evaluate(X);

	}
      

      sort(MinMax,eval,population,pop_size,x2_vari);

      switch(MinMax)
	{
	case 0:
	  if(Teval > eval[1])
	    {
	      fprintf(output,"Generation #%d; the current best value is %f\n",count_gener,eval[1]); 
	      Teval = eval[1];
	    }
	  break;
	case 1:
	  if(Teval < eval[1])
	    {
	      fprintf(output,"Generation #%d; the current best value is %f\n",count_gener,eval[1]); 
	      Teval = eval[1];
	    }
	  break;
      }

      count_gener++;
      
    }while(count_gener <= generations);
  
  fprintf(output,"\n\nTHE FINAL BEST VALUE FOUND IS: %f\n\n\n",eval[1]); 
  
  print_population(pop_size,x2_vari+tot_eq,print_pop);
}

int find_parent(live,pop_size)
int pop_size; 
IVECTOR live; 
              
{
  int i,temp,t1,t2=0,tot=0;


  for(i=1; i<=pop_size; i++)
    tot = tot + live[i];
  if(tot==0)
    {
      printf("No agents to select\n");
      exit(1);
    }

  temp = irange_ran(1,tot);

  tot = 0;
  i = 1;
  do{
    if(live[i]!=0)
      t1 = i;
    tot = tot + live[i++];
  }while(tot<temp);


  live[t1]--;
  return(t1);
}



void sort(MinMax,eval,population,pop_size,x2_vari)
int MinMax,       
    x2_vari,      
    pop_size;     
VECTOR eval;      
MATRIX population;
{
  int i,j,k;


  switch(MinMax)
    {
    case 0 :
      for(i=1; i<=pop_size; i++)
	for(j=i+1; j<=pop_size; j++)
	  {
	    if(eval[i] > eval[j])
	      {
		swap(&eval[i],&eval[j]);
		for(k=1; k<= x2_vari; k++)
		  swap(&population[i][k],&population[j][k]);
	      }
	  }
      break;
    case 1 :
      for(i=1; i<=pop_size; i++)
	for(j=i+1; j<=pop_size; j++)
	  {
	    if(eval[i] < eval[j])
	      {
		swap(&eval[i],&eval[j]);
		for(k=1; k<= x2_vari; k++)
		  swap(&population[i][k],&population[j][k]);
	      }
	  }
      break;
    default:
      fprintf(output,"Incorrect data: Must be a 0 or 1");
      exit(1);
    }
}


void swap(x,y)
float *x,*y;
{
  float temp;

  temp = *x;
  *x = *y;
  *y = temp;
}
    
void assign_probab(probab,pop_size,Q)
int pop_size;  
float Q;       
VECTOR probab; 
               
{
  int i;
  

  for(i=1; i<=pop_size; i++)
    probab[i] = Q * x_pow_y(1-Q,i-1);
}


float x_pow_y(x,y)
float x;
int y;
{
  int i;
  float tot = 1.0;
  
  for(i=0; i < y; i++)
    tot = tot * x;
  return(tot);
}


void find_cum_probab(cum_probab,probab,pop_size)
int pop_size;     
VECTOR probab,    
       cum_probab;
{
  int i;
  
  cum_probab[1] = probab[1];

  for(i=2; i<=pop_size; i++)
    cum_probab[i] = cum_probab[i-1] + probab[i];

}


void find_live_die(cum_probab,live,die,pop_size,P)
VECTOR cum_probab;
IVECTOR live,     
        die;      
int pop_size,     
    P;            
{
  float random;
  int count_live=0,
      i;

  do
    {

      random = frange_ran(0.0,1.0);
      i=0;

      do{
	i++;
	}while((random > cum_probab[i]) && (i< pop_size));
	

      if(count_live < P)
	{
	  live[i]++;
	  die[pop_size+1 - i] = 1;
	  count_live++;
	}
    }while(count_live < P); 
}


void find_X(final,agent,X,x2_vari,tot_eq,x1,x2,a1_b)
MATRIX final;
VECTOR agent,X,a1_b;
IVECTOR x1,x2;
int x2_vari,tot_eq;
{
  int i,j;

  for(j=1; j<=x2_vari; j++)
    X[x2[j]] = agent[j];

  for(j = 1; j<=tot_eq; j++)
    {
      X[x1[j]] = a1_b[j];
      for(i=1; i<=x2_vari; i++)
	X[x1[j]] = X[x1[j]] + agent[i] * final[j+x2_vari][i+1];
    }
}

