#define _ERRORCHECK_
#include <stdio.h>
#include <math.h>

#define     N         7   /* max number of destinations */
#define     K         7   /* max number of sources */
#define MAXIM         50  /* N times K */
#define   POP         70  /* max size of population */
#define   licz    2147483647.0
#define	MINUSINF	-99999.0
#define epsilon      0.001

#ifndef EXTERN
#define EXTERN extern
#endif

typedef struct  {
	double sol[K][N];
	double eval;
	} SOLN;

EXTERN int alpha; 	       /* control variable; might be useful in testing */
EXTERN SOLN population[POP];   /* population itself */
EXTERN SOLN *pp [POP];         /* population pointer */
EXTERN double par[K][N];       /* parent for mutation */
EXTERN double chd[K][N];       /* child after mutation */
EXTERN double par_a[K][N];     /* first parent for crossover */
EXTERN double par_b[K][N];     /* second parent for crossover */
EXTERN double chd_a[K][N];     /* first child from crossover */
EXTERN double chd_b[K][N];     /* second child from crossover */
EXTERN double dest[N];         /* array of destination values */
EXTERN double sour[K];         /* array of source values */
EXTERN double cost[K][N];      /* array of costs */
EXTERN double initial[K][N];   /* an initial population */
EXTERN double eval[POP];       /* array of values of solutions */
EXTERN double optimum;         /* The (known) optimum value */
EXTERN double prob[POP];    /* array of probabilities */
EXTERN int parents[POP];    /* array of parents */
EXTERN int dead[POP];       /* array of dead */

EXTERN int pop;				/* size of population */
EXTERN int k;				/* number of sources */
EXTERN int n;				/* number of destinations */
EXTERN int it;				/* number of iterations for evolution */
EXTERN double sprob;   		/* the selection probability */
EXTERN int reprod;	  	 	/* the number of parents */
EXTERN int cross;           /* the number of crossovers in one generation */
EXTERN int inver;           /* the number of inversions in one generation */
EXTERN int mutat;           /* the number of mutations in one generation */
EXTERN double fixed;        /* the constant for nonlinear evaluation function */

              /* reprod = inver + mutat + cross */

EXTERN double cross_1;      /* the first parameter for crossover */
EXTERN double cross_2;      /* the second parameter for crossover */

               /* cross_1 + cross_2 = 1.0000000 */
       
EXTERN unsigned int seed0; /* the starting seed note: int on MacII,  */

