/****************************************************************************

	Standard math library header for LightspeedC.

	(C) Copyright 1986 THINK Technologies, Inc.  All rights reserved.

*****************************************************************************/

#ifndef	_math_

	#define	_math_							/* show symbols defined	*/
	#define	PI		(3.14159265358979323846)
	#define	PI2		(1.57079632679489661923)
	#define	PI4		(0.78539816339744830966)

	#define	E		(2.71828182845904523536)

	typedef enum{
					EDOM=33,
					ERANGE=34
				};

int abs(int i);
long labs(long l);

#ifdef _MC68881_
#ifdef _ERRORCHECK_
	double	acos(double x);
	double	asin(double x);
	double	atan(double x);
	double	atan2(double y, double x);
	double	ceil(double x);
	double	cos(double x);
	double	cosh(double x);
	double	exp(double x);
	double	fabs(double x);
	double	floor(double x);
	double	fmod(double x, double y);
	double	frexp(double x, int *i);
	double	ldexp(double x, int n);
	double	log(double x);
	double	log10(double x);
	double	modf(double x, int *i);
	double	pow(double x, double y);
	double	sin(double x);
	double	sinh(double x);
	double	sqrt(double x);
	double	tan(double x);
	double	tanh(double x);
	
	#else
	
	double	_acos(double x);
	double	_asin(double x);
	double	_atan(double x);
	double	_atan2(double y, double x);
	double	_ceil(double x);
	double	_cos(double x);
	double	_cosh(double x);
	double	_exp(double x);
	double	_fabs(double x);
	double	_floor(double x);
	double	_fmod(double x, double y);
	double	_frexp(double x, int *i);
	double	_ldexp(double x, int n);
	double	_log(double x);
	double	_log10(double x);
	double	_modf(double x, int *ip);
	double	_pow(double x, double y);
	double	_sin(double x);
	double	_sinh(double x);
	double	_sqrt(double x);
	double	_tan(double x);
	double	_tanh(double x);

	#define acos(x)		_acos(x)
	#define asin(x)		_asin(x)
	#define atan(x) 	_atan(x)
	#define atan2(y, x) _atan2(y, x)
	#define ceil(x) 	_ceil(x)
	#define cos(x)		_cos(x)
	#define cosh(x)		_cosh(x)
	#define exp(x)		_exp(x)
	#define fabs(x)		_fabs(x)
	#define floor(x)	_floor(x)
	#define fmod(x, y)	_fmod(x, y)
	#define frexp(x, i) _frexp(x, i)
	#define ldexp(x, n) _ldexp(x, n)
	#define log(x)		_log(x)
	#define log10(x)	_log10(x)
	#define modf(x, ip) _modf(x, ip)
	#define pow(x, y)	_pow(x, y)
	#define sin(x)		_sin(x)
	#define sinh(x)		_sinh(x)
	#define sqrt(x)		_sqrt(x)
	#define tan(x)		_tan(x)
	#define tanh(x)		_tanh(x)

	#endif /* _ERRORCHECK_ */

	typedef struct {
		long long1;
		long long2;
	} TwoLongs;		/* the mantissa of a double, be it 80 or 96 bits */
	
	/* 80-bit extended */
	typedef struct {
		int			exponent;			/* word also contains sign bit */
		TwoLongs	mantissa;
	} Extended80;
	
	/* 96-bit extended */
	typedef struct {
		int			exponent;			/* word also contains sign bit */
		int			reserved;			/* extra 16 bits of zero reserved for 68881 */
		TwoLongs	mantissa;
	} Extended96;
#endif

#ifdef _ERRORCHECK_
extern	int	errno;	/* actually defined in stdio */
#endif /* _ERRORCHECK */
 
#ifndef _MC68881_
	double	acos(double x);
	double	asin(double x);
	double	atan(double x);
	double	atan2(double y, double x);
	double	ceil(double x);
	double	cos(double x);
	double	cosh(double x);
	double	exp(double x);
	double	fabs(double x);
	double	floor(double x);
	double	fmod(double x, double y);
	double	frexp(double x, int *i);
	double	ldexp(double x, int n);
	double	log(double x);
	double	log10(double x);
	double	modf(double x, int *i);
	double	pow(double x, double y);
	double	sin(double x);
	double	sinh(double x);
	double	sqrt(double x);
	double	tan(double x);
	double	tanh(double x);
#endif

#endif /* _math_ */