;;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GECO -*-

(in-package :GECO)
#|
Genetic Evolution through Combination of Objects (GECO)

Copyright (C) 1992  George P. W. Williams, Jr.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
|#

(defmethod SHARED-INITIALIZE :AFTER ((self population-statistics) slots-for-initform
                                     &REST initargs)
  (declare (ignore slots-for-initform initargs))
  (compute-statistics self))

(defmethod PRINT-OBJECT ((self population-statistics) stream)
  (print-unreadable-object (self stream :type t :identity t)
    (princ (if (slot-boundp self 'avg-normalized-fitness)
               (format nil "[avg-norm-fit: ~,2F]"
                       (avg-normalized-fitness self))
             (format nil "[converged: ~F]" (avg-fitness self)))
           stream)))

(defmethod COMPUTE-STATISTICS ((self population-statistics))
  (with-accessors ((size size)
                   (orgs organisms))
                  (population self)
    (with-accessors ((sum sum-fitness)
                     (max max-fitness)
                     (min min-fitness)) self
      (let ((fit0 (fitness (aref orgs 0))))
        (setf sum (float fit0)
              max fit0
              min fit0))
      (do* ((i 1 (1+ i))
            fit-i)
           ((>= i size))
        (setq fit-i (fitness (aref orgs i)))
        (incf sum fit-i)
        (if (< max fit-i) (setq max fit-i))
        (if (> min fit-i) (setq min fit-i)))
      (setf (avg-fitness self) (/ sum size)))))

(defmethod COMPUTE-NORMALIZED-STATISTICS ((self population-statistics)
                                          &AUX min max)
  (with-accessors ((size size)
                   (orgs organisms))
                  (population self)
    (with-accessors ((sum sum-normalized-fitness)) self
      (let ((fit0 (normalized-fitness (aref orgs 0))))
        (setf sum (float fit0)
              max fit0
              min fit0))
      (do* ((i 1 (1+ i))
            fit-i)
           ((>= i size))
        (setq fit-i (normalized-fitness (aref orgs i)))
        (incf sum fit-i)
        (if (< max fit-i) (setq max fit-i))
        (if (> min fit-i) (setq min fit-i)))
      (setf (avg-normalized-fitness self) (/ sum size)))))
