;;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GECO -*-

(in-package :GECO)
#|
Genetic Evolution through Combination of Objects (GECO)

Copyright (C) 1992  George P. W. Williams, Jr.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
|#

(defmethod SHARED-INITIALIZE :AFTER ((self ecosystem) slots-for-initform &REST initargs
                                     &KEY
                                     plan-class pop-class pop-size
                                     generation-limit evaluation-limit)
  (declare (ignore slots-for-initform initargs))
  (setf (population self)
        (make-population self pop-class
          :size pop-size))
  (setf (plan self)
        (make-genetic-plan self plan-class))
  (if generation-limit
    (setf (generation-limit (plan self)) generation-limit))
  (if evaluation-limit
    (setf (evaluation-limit (plan self)) evaluation-limit)))

(defmethod MAKE-POPULATION ((ecosystem ecosystem) pop-class &KEY size)
  (make-instance pop-class
    :ecosystem ecosystem
    :size size))

(defmethod MAKE-GENETIC-PLAN ((ecosystem ecosystem) plan-class)
  (make-instance plan-class :ecosystem ecosystem))

(defmethod EVOLVE ((self ecosystem))
  (evaluate self (plan self))
  (unless (evolution-termination-p (plan self))
    (incf (generation-number self))
    (regenerate (plan self) self)
    (evolve self)))

(defmethod EVALUATE ((self ecosystem) (plan genetic-plan))
  (evaluate (population self) plan))
