;;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GECO -*-

(in-package :GECO)
#|
Genetic Evolution through Combination of Objects (GECO)

Copyright (C) 1992  George P. W. Williams, Jr.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
|#

(defclass ECOSYSTEM ()
  ((PLAN
    :accessor plan
    :type genetic-plan)
   (POPULATION                         ;all the organisms
    :accessor population
    :type population)
   ;; see evolution-termination-p for the usage of the following two slots
   (GENERATION-NUMBER
    :accessor generation-number
    :initform 0
    :type integer)
   (EVALUATION-NUMBER
    :accessor evaluation-number
    :initform 0
    :type integer)))

(defclass GENETIC-PLAN ()
  ((ECOSYSTEM
    :accessor ecosystem
    :initarg :ecosystem
    :type ecosystem)
   (STATISTICS
    :accessor statistics
    :initarg :statisics)
   ;; see evolution-termination-p for the usage of the following two slots
   (GENERATION-LIMIT
    :accessor generation-limit
    :initarg :generation-limit
    :initform nil
    :type (or integer null)
    :documentation
    "If non-nil, it should be an integer, the final evaluation number.")
   (EVALUATION-LIMIT
    :accessor evaluation-limit
    :initarg :evaluation-limit
    :initform nil
    :type (or integer null)
    :documentation
    "If non-nil, it should be an integer, the final generation number.")))

(defclass PLAN-STATISTICS ()
  ())

(defclass POPULATION ()
  ((ECOSYSTEM
    :accessor ecosystem
    :initarg :ecosystem
    :type ecosystem)
   (ORGANISMS
    :accessor organisms
    :type vector)
   (SIZE
    :accessor size
    :initarg :size
    :initform nil
    :type (or fixnum null))
   (STATISTICS
    :accessor statistics
    :initarg :statistics
    :type population-statistics)))

(defclass GENERATIONAL-POPULATION (population)
  ((PREVIOUS-POPULATION
    :accessor previous-population
    :initform NIL
    :type (or population nil))))

(defclass POPULATION-STATISTICS ()
  ((POPULATION
    :accessor population
    :initarg :population
    :type population)
   ;; the following slots are set by compute-statistics
   (SUM-FITNESS
    :accessor sum-fitness
    :initarg :sum-fitness
    :type number)
   (AVG-FITNESS
    :accessor avg-fitness
    :initarg :avg-fitness
    :type number)
   (MAX-FITNESS
    :accessor max-fitness
    :initarg :max-fitness
    :type number)
   (MIN-FITNESS
    :accessor min-fitness
    :initarg :min-fitness
    :type number)
   ;; the following slots are set by compute-normalized-statistics
   (SUM-NORMALIZED-FITNESS
    :accessor sum-normalized-fitness
    :initarg :sum-normalized-fitness
    :type short-float)
   (AVG-NORMALIZED-FITNESS
    :accessor avg-normalized-fitness
    :initarg :avg-normalized-fitness
    :type short-float)))

(defclass ORGANISM ()
  ((POPULATION
    :accessor population
    :initarg :population
    :initform 'nil
    :type (or population null))
   (GENOTYPE                            ;one or more chromosomes
    :accessor genotype
    :initarg :genotype
    :initform 'nil
    :type list)
   (PHENOTYPE                           ;the actual resulting organism
    :accessor phenotype
    :initarg :phenotype)
   (FITNESS
    :accessor fitness
    :initarg :fitness
    :initform 'nil
    :type number)
   (NORMALIZED-FITNESS
    :accessor normalized-fitness
    :initarg :normalized-fitness
    :initform 'nil
    :type (or short-float null))))

(defclass CHROMOSOME ()
  ((ORGANISM
    :accessor organism
    :initarg :organism
    :initform 'nil
    :type (or organism null))
   (LOCI
    :accessor loci
    :initarg :loci
    :type array)))

(defclass BINARY-CHROMOSOME (chromosome)
  ())

(defclass MULTI-STRAND-CHROMOSOME (chromosome)
  ((CHROMPACK
    :accessor loci
    :initarg :loci
    :type (array chromosome *))))

(defclass GRAY-CODE-TRANSLATION ()
  ((NUMBER-OF-BITS
    :accessor number-of-bits
    :initarg :number-of-bits  ; must be supplied either at instantiation or instance [re-]initialization time
    :type fixnum)
   (B2G-MAP
    :accessor b2g-map
    :type (array bit (* *)))
   (G2B-MAP
    :accessor g2b-map
    :type (array bit (* *)))))
