//				GSTREAM.CC
// Implementation of functions for gstream

#include <fstream.h>
#include <string.h>

#include "general.hpp"
#include "gstream.hpp"

//-----------------------------------------
gstream::gstream( char* _initStr, plotType _plType = LINES,  bool _flush = TRUE ){
// --	Initializes the stream
//	flush=TRUE means that the file will be reread and replot every time
// ----------------------------------------
    
    gnuFile = popen( "gnuplot", "w" );
    if (!gnuFile) {
	cerr << "gnuPlot is not present or whatever other circunstance\n";
	exit(1);
    }    
    fprintf( gnuFile, "%s\n", _initStr );
    
    sprintf( tempGnu, "gnu.tmp%d", myrand(10000) );
    ios::sync_with_stdio();
    tempF.open( tempGnu, ios::out); 
    
    
    // assign to instance variables
    switch ( _plType ) {
	case LINES : plType = 'l'; break;
	case DOTS : plType = 'd'; break;
	case POINTS : plType = 'p'; break;	
    }
    flush = _flush;
    if (flush)
	tempF.close();			    // to create it
}


//-----------------------------------------
gstream::~gstream( ){
// -- Closes everything and removes things
// ----------------------------------------
    const char constGnu[17] = tempGnu;	    // little trick to make vars const
    if (!flush)
	tempF.close();
    pclose( gnuFile );
    remove( constGnu );
}

//-----------------------------------------
void gstream::rePlot( ){
// -- Plots whatever is in the file
// ----------------------------------------
    fprintf( gnuFile, "plot \"%s\" w %c\n",  tempGnu, plType );
    fflush( gnuFile);
}


//-----------------------------------------
void gstream::reStart( void ) {
// -- Empties the buffer, and starts all over again
//-----------------------------------------  
    
    if ( !flush ) 
	rePlot();
    else
	tempF.open( tempGnu, ios::out );    // puts pointer at the beginning
    tempF.close();			// of the file and closes it
    if ( !flush ) 
	tempF.open( tempGnu, ios::out );    // puts pointer at the beginning
}


//----------------------------------------------
gstream& operator << ( gstream& _gnu, float _out){
// -- output functions
//----------------------------------------------    
    if ( _gnu.flush )
	_gnu.tempF.open( _gnu.getTemp(), ios::out|ios::app);	    
					    // open for output && append
    _gnu.tempF << _out << "\n";
    
    if ( _gnu.flush ) {
	_gnu.tempF.close();
	_gnu.rePlot();
    }  
}

//----------------------------------------------
gstream& operator << ( gstream& _gnu, float* _out){
// --	output functions; takes only the first 2 elements of the
//	array
//---------------------------------------------- 
    if ( _gnu.flush )   
	_gnu.tempF.open( _gnu.getTemp(), ios::out|ios::app);	    
						    // open for output && append
    _gnu.tempF << _out[0] << " " << _out[1] << "\n";	    // cannot have more than 2 comps
    if ( _gnu.flush ) {
	_gnu.tempF.close();
	_gnu.rePlot();  
    }
}


//----------------------------------------------
gstream& operator << ( gstream& _gnu, char* _out){
// -- output functions
//----------------------------------------------    

    if (_gnu.flush )
	_gnu.tempF.open( _gnu.getTemp(), ios::out|ios::app);	    
					    // open for output && append
    _gnu.tempF << _out << "\n";		    // cannot have more than 2 comps
    if (_gnu.flush ) {
	_gnu.tempF.close();
	_gnu.rePlot();  
    }
}
