// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; c++-electric-colon 1; c-auto-newline 1 -*-
// ------------------------------ GENSGAV.CC ----------------------------------
// implementation of the gensga class


#include "gensgav.hpp"


#ifndef __BCPLUSPLUS__
#ident "@(#) gensgav.cc -- By JJ Merelo "
#endif


// --------------------------------------------
unsigned char deGray( unsigned char _deG ) {
// --	Pases from Gray Code to the decimal
//	representation. The formula is
//	y7 = x7
//	y6 = x7 ^ x6... and so on
// ---------------------------------------------
    
    unsigned char outG = _deG & Wgts[1];
    unsigned char thisBit = outG;
    for ( unsigned char i = 2; i <= 8; i ++ ) {
#ifdef DEBUG
	unsigned char prevOutG = outG;
#endif
	thisBit = (thisBit >> 1 ) ^ (_deG & Wgts[i]);
	outG |= thisBit;
#ifdef DEBUG
	printf( "%d %d %d %o %o %o\n",  i,(prevOutG >> 1 ),  (_deG & Wgts[i]), outG, _deG, Wgts[i] );
#endif
    }

    return outG;
}
