//		    EZSAMPLE.HPP
//  Easy class that loads a file and places it in a matrix. Operators duly overloaded

// LOG
// 13-May-94 : Aniadida getSize

#include <fstream.h>
#include <string.h>

template <class vecType>
class ezSample {
    vecType ** inSample;
    unsigned size;		// file & array size
    unsigned vecSize;		// vector Size
    
public:
    ezSample( const char * _fName, unsigned _vecSize );
    ~ezSample();
    
    vecType* operator [] ( unsigned _idx ) const { return ( _idx<size)?inSample[_idx]:0; }
    unsigned getSize ( void ) const { return size;};
    
};

// ---------------------------------------------------------------------
template <class vecType>
ezSample<vecType>::ezSample( const char * _fName, unsigned _vecSize ) {
// -- Main constructor
// ---------------------------------------------------------------------

    // first compute size
    ifstream fin( _fName );
    char foo[300];
    unsigned numLines = 0;
    do {	
	fin.getline( foo, 299 );
	numLines ++ ;
    } while ( strlen(foo) > 0 );
    size = --numLines;
    fin.close();
    // dim everything
    inSample = new vecType * [size];
    if (!inSample) {
	    cout << "No more memory\n";
	    exit(1);
    }
    
    vecSize = _vecSize;
    
    fin.open( _fName, ios::in );
    for ( unsigned i = 0; i < size; i ++ ) {
	inSample[i] = new vecType[ vecSize ];
	if (!inSample[i]) {
	    cout << "No more memory\n";
	    exit(1);
	}
	for (unsigned j = 0; j < vecSize; j ++ )
	    fin >> inSample[i][j];
    }
    
    fin.close();
    
};


// ---------------------------------------------------------------------
template <class vecType>
ezSample<vecType>::~ezSample() {
// -- Main destructor
// ---------------------------------------------------------------------
    for ( unsigned i = 0; i < size; i ++ ) 
	delete inSample[i];
	
    delete[] inSample;
};
