// -----------------------------------	POPSGAp.HPP -----------------------------------
// DESCRIPTION :    class to handle a population of fixed-length genomes using a SGA
//		    This p version uses 2 templates, since I learned how to handle
//		    them

// REFERENCES	: Goldbergs book, JJs thesis, and many other things.

// LOG :
// 6-May-94 : Startin, man!
// 8-May-94 :	Aniadida la funcion Rank, para poner por orden, y otras relacionadas
//10-May-94 :	Modificaciones para tener en cuenta la nueva clase genSGAv
//		Y se convierte en polimorfica, toma sha!
//		Remodificada, para que herede de POPS
//13-May-94 :	Aniadidas un par de funciones, mejor fitness y mejor vector
//18-May-94 :	Modificado lo de seleccion de ruleta, que parece dar error


#ifndef __POPSGAP_HPP
#define __POPSGAP_HPP

#ifndef __BCPLUSPLUS__
#ident "@(#) popsgar.hpp -- By JJ Merelo "
#endif


#include "gensga.hpp"
#include "gensgav.hpp"
#include "pops.hpp"


template <class returnType, class genType>
class popSGAr: public popS<returnType>{
    genType **pop, **genePool;  // current population and genePool
    

    // private funcs
    void allocMem();
        
public:

    // constructors and destructors
    popSGAr( unsigned _numParams, unsigned _sizeParams, 
	    returnType* _rgStart, returnType* _rgEnd,
	    unsigned _popSize,  double _mutationRate );
	    
    popSGAr( unsigned _numParams, unsigned _sizeParams, 
	    returnType _rgStart, returnType _rgEnd,
	    unsigned _popSize,  double _mutationRate );
	    
    virtual ~popSGAr();    
    
    
    // look inside functions
    genSGAv<returnType> * operator [] ( unsigned _genomeIdx ) const {
	return pop[_genomeIdx];
    };
    
    genType& bestIndiv( void ) const { return (*pop[ rank[0]]); };
   	
    // Roulette wheel functions		    
    virtual void createRWPool( void);	    // creates roulette wheel pool, 
					    // according to fitness
    virtual void reproducePool( void);	    // reproduces from genePool
    
    // genetic operators
    virtual void Clone( unsigned _winner,  unsigned _newPos );	    
					    // clones with mutation
    virtual void Mate(	unsigned _par1,		    // mates them with given mutationRate
		unsigned _par2,		    // places result in the population
		unsigned _sib );  
		
    virtual void eliteMate(
		unsigned _par1,		    // mates them with given mutationRate
		unsigned _par2,		    // places result in the population
		unsigned _sib );	    // does not use genePool
	   
};



//  TEMPLATE DEFINITION-------------------------------

// -----------------------------------------------------------------
template <class returnType, class genType>
void popSGAr<returnType, genType>::allocMem() {
// allocs memory, and checks
// -----------------------------------------------------------------
    // memory allocation
    if ( !(pop = new genType*[popSize] ) ) {
	cout << "Not enough memory for the population\n";
	exit (1);    
    }
    
    if ( !(genePool = new genType*[popSize] ) ) {
	cout << "Not enough memory for the population\n";
	exit (1);    
    }
    
   
}

// -----------------------------------------------------------------
template <class returnType, class genType >
popSGAr<returnType, genType >::popSGAr( unsigned _numParams, unsigned _sizeParams, 
	    returnType _rgStart, returnType _rgEnd,
	    unsigned _popSize,  double _mutationRate ):popS<returnType>( _popSize, _mutationRate) {
// -- Main constructor -- only for genSGA
// -----------------------------------------------------------------
    
    // parameter check
    if (!_popSize) {
	    cout << "Population size is 0\n";
	    exit(1);
    }
    
    popSize = _popSize;    
    mutationRate = _mutationRate;
    
    allocMem();
    
    // population inisialitation
    for ( unsigned i = 0; i < popSize; i ++ ){
	pop[i]= new genType( _numParams, _sizeParams, _rgStart, _rgEnd);
	genePool[i]=NULL;
	fitness[i]=0;
    }
    
};


// -----------------------------------------------------------------
template <class returnType, class genType >
popSGAr<returnType, genType >::popSGAr( unsigned _numParams, unsigned _sizeParams, 
	    returnType* _rgStart, returnType* _rgEnd,
	    unsigned _popSize,  double _mutationRate ):popS<returnType>( _popSize, _mutationRate) {
// -- Main constructor -- only for SGAv
// -----------------------------------------------------------------
    
    // parameter check
    if (!_popSize) {
	    cout << "Population size is 0\n";
	    exit(1);
    }
    
    popSize = _popSize;    
    mutationRate = _mutationRate;
    
    allocMem();
    
    // population inisialitation
    for ( unsigned i = 0; i < popSize; i ++ ){
	pop[i]= new genType( _numParams, _sizeParams, _rgStart, _rgEnd);
	genePool[i]=NULL;
	fitness[i]=0;
    }
    
};
    
    
// -----------------------------------------------------------------
template <class returnType, class genType>
popSGAr<returnType, genType>::~popSGAr() {
// -- class destructor
// -----------------------------------------------------------------
    
    // population destruction
    for ( unsigned i = 0; i < popSize; i ++ ){
	delete pop[i];
    }
    delete[] genePool;
    delete[] pop;
    
};


// ------------------------------------------------------------------
template <class returnType, class genType>
void popSGAr<returnType, genType>::Clone( unsigned _winner,  unsigned _newPos ){
// --	clones a genome and places it in the genePool
//	must be made before Mating
// -----------------------------------------------------------------
    genePool[ _newPos ] = new genType( *pop[_winner], mutationRate );
}

// -----------------------------------------------------------------
template <class returnType, class genType>
void popSGAr<returnType, genType>::Mate( unsigned _par1, unsigned _par2,  unsigned _sib ){
// --	makes both happy parents mate, places result in the population; _sib
//	is the sibling. Must be made _after_ cloning
// -----------------------------------------------------------------

    // first, kill former occupant of the sibling place
    delete pop[_sib];
    
    // now, mate, first, generate two random crossover points
    unsigned long x1 = myrand( genePool[_par1]->getLength()*8);
    unsigned long x2 = myrand( genePool[_par1]->getLength()*8);
    
    pop[_sib] = new genType( *(genePool[_par1]), *(genePool[ _par2 ]), x1, x2, mutationRate );

    
    // once used, discard them
    // delete genePool[_par1];
    // delete genePool[_par2]; 
    
};
	
	
	
// -----------------------------------------------------------------
template <class returnType, class genType>
void popSGAr<returnType, genType>::eliteMate( unsigned _par1, unsigned _par2,  unsigned _sib ){
// --	makes both happy parents, from the population, mate, places result in the 
//	population again; _sib is the sibling. Corresponds to elite
//	selection; checks that none of them is equal
// -----------------------------------------------------------------

    if ( (_par1 == _sib) || (_par2 == _sib ) ) {
	cout << "Be careful with indices\n";
	return;
    }
    
    // first, kill former occupant of the sibling place
    delete pop[_sib];
    
    // now, mate, first, generate two random crossover points
    unsigned long x1 = myrand( pop[_par1]->getLength()*8);
    unsigned long x2 = myrand( pop[_par1]->getLength()*8);
    
    pop[_sib] = new genType( *(pop[_par1]), *(pop[ _par2 ]), x1, x2, mutationRate );
   
};



// -----------------------------------------------------------------
template <class returnType, class genType>
void popSGAr<returnType, genType>::createRWPool(){
// --	Creates a pool of genomes, cloning with mutation according
//	to fitness
// -----------------------------------------------------------------

    // Compute partial sums of fitness
    returnType *sumParFitness = new returnType[popSize];
    sumParFitness[0] = fitness[0];
    for ( unsigned i = 1; i < popSize; i++ )
	sumParFitness[i]=fitness[i]+sumParFitness[i-1];
    
    // select each new member of the population
    for ( i = 0; i < popSize; i ++ ) {
	returnType slot = myrand(10000)/10000.0*sumParFitness[popSize-1];
	unsigned j = 0;
	while ( slot > sumParFitness[j++]);
	// j has been selected
	Clone(j-1, i);			// and transferred to the genePool
    }
    delete []sumParFitness;		// memory deallocation
	   
}


// -----------------------------------------------------------------
template <class returnType, class genType>
void popSGAr<returnType, genType>::reproducePool(){
// --	Takes random couples from the genePool, and mates them.
//	once done, cleans genePool
// -----------------------------------------------------------------

    for ( unsigned i = 0; i < popSize; i++ ) {
	// select 2 random parents
	unsigned pop1 = myrand( popSize );
	unsigned pop2 = myrand( popSize );
	Mate( pop1, pop2, i );
    }
    
    // now clean genePool
    for ( i = 0; i < popSize; i++ ) 
	delete genePool[i];
}







#endif
