// -----------------------------------	POPS.HPP -----------------------------------
// DESCRIPTION :    class to handle a population of fixed-length genomes using a SGA
//		    Several classes inherit from it, depending on the type of genome

// REFERENCES	: Goldbergs book, JJs thesis, and many other things.

// LOG :
// 6-May-94 : Startin, man!
// 8-May-94 :	Aniadida la funcion Rank, para poner por orden, y otras relacionadas
//10-May-94 :	Modificaciones para tener en cuenta la nueva clase genSGAv
//		Y se convierte en polimorfica, toma sha!



#ifndef __POPS_HPP
#define __POPS_HPP

#ifndef __BCPLUSPLUS__
#ident "@(#) pops.hpp -- By JJ Merelo "
#endif

#include "general.hpp"			    // para swap

template <class returnType>
class popS{

protected:
    returnType*		fitness;	    // array of fitness for each individual
    unsigned *		rank;		    // rank according to fitness
    unsigned		popSize;	    // population size
    double		mutationRate;	    // rate of mutation
    
public:

    // constructors and destructors
    popS( unsigned _popSize,  double _mutRate );
	
    virtual ~popS();    
	    
    // "peeping Tom" functions
    unsigned	getPopSize	( void) const { return popSize; };
    returnType	getFitness	( unsigned _idx ) const { return fitness[_idx];};
    
    
    // assignation functions
    void    setFitness( unsigned _idx, 
			returnType _value ) { 
	(_idx < popSize)?(fitness[_idx] = _value):0;
    }
    
    
    // selection and other population functions
    void Rank();			    // orders according to fitness
    unsigned index2rank( unsigned _idx ) {  // return the genome whose fitness
	return rank[_idx];		    // is in _idx_ position
    }
    unsigned index2best( void) { return rank[0];}
					    // same, with the best
    returnType bestFitness( void ) const { return fitness[rank[0]]; };
					    
    virtual void createRWPool( void) = 0;   // creates roulette wheel pool, 
					    // according to fitness
    virtual void reproducePool( void) = 0;  // reproduces from genePool
    
    // genetic operators
    virtual void Clone( unsigned _winner,  unsigned _newPos ) = 0;	    
					    // clones with mutation
    virtual void Mate(	unsigned _par1,		    // mates them with given mutationRate
		unsigned _par2,		    // places result in the population
		unsigned _sib ) = 0;  
		
    virtual void eliteMate(
		unsigned _par1,		    // mates them with given mutationRate
		unsigned _par2,		    // places result in the population
		unsigned _sib ) = 0;	    // does not use genePool

};		// end class definition


//  TEMPLATE DEFINITION-------------------------------

// -----------------------------------------------------------------
template <class returnType>
popS<returnType>::popS( unsigned _popSize,  double _mutRate) {
// allocs memory, and checks
// -----------------------------------------------------------------
    
    popSize = _popSize;
    mutationRate = _mutRate;
    
    if ( !(fitness = new returnType[_popSize] ) ){
	cout << "Not enough memory for fitness array\n";
	exit(1);
    }
    
    if ( !(rank = new unsigned[_popSize] ) ){
	cout << "Not enough memory for rank array\n";
	exit(1);
    }
}



    
// -----------------------------------------------------------------
template <class returnType>
popS<returnType>::~popS() {
// -- class destructor
// -----------------------------------------------------------------
    
    delete[] rank;
    delete[] fitness;
    
};




// -----------------------------------------------------------------
template <class returnType>
void popS<returnType>::Rank(){
// --	Orders the population according to fitness, places the rank
//	in the array rank.
// -----------------------------------------------------------------


    // Well use the simpler way, damn the name, I cannot remember
    // yep, its selection ordering, look it up in the Schildt
    
    for (unsigned i = 0; i < popSize; i ++ ) {
	    rank[i]=i;
    }
    
    for ( i = 0; i < popSize; i ++ ) {
	    unsigned boss = i;
	    for ( unsigned j =i; j < popSize; j ++ ) {
		if (fitness[rank[j]] > fitness[rank[boss]] )
		    boss = j;
	    }
	    if ( boss != i )
		swap( rank[i], rank[boss] );
    }
	   
}



#endif
