//				GSTREAM.CC
// Implementation of functions for gstream

#include <fstream.h>
#include <string.h>

#include "general.hpp"
#include "gstream.hpp"

//-----------------------------------------
gstream::gstream( char* _initStr){
// -- Initializes the stream
// ----------------------------------------
    
    gnuFile = popen( "gnuplot", "w" );
    if (!gnuFile) {
	cerr << "gnuPlot is not present or whatever other circunstance\n";
	exit(1);
    }    
    fprintf( gnuFile, "%s\n", _initStr );
    
    sprintf( tempGnu, "gnu.tmp%d", myrand(10000) );
    ios::sync_with_stdio();
    fstream tempF( tempGnu, ios::out); 
    tempF.close();			    // to create it
    
}


//-----------------------------------------
gstream::~gstream( ){
// -- Closes everything and removes things
// ----------------------------------------
    const char constGnu[17] = tempGnu;	    // little trick to make vars const
    pclose( gnuFile );
    remove( constGnu );
}

//-----------------------------------------
gstream::rePlot( ){
// -- Plots whatever is in the file
// ----------------------------------------
    fprintf( gnuFile, "plot \"%s\" w l\n",  tempGnu );
    fflush( gnuFile);
}


//----------------------------------------------
gstream& operator << ( gstream& _gnu, float _out){
// -- output functions
//----------------------------------------------    
    fstream tempF( _gnu.getTemp(), ios::out|ios::app);	    
					    // open for output && append
    tempF << _out << "\n";
    tempF.close();
    _gnu.rePlot();  
}

//----------------------------------------------
gstream& operator << ( gstream& _gnu, float* _out){
// -- output functions
//----------------------------------------------    
    fstream tempF( _gnu.getTemp(), ios::out|ios::app);	    
					    // open for output && append
    tempF << _out[0] << " " << _out[1] << "\n";		    // cannot have more than 2 comps
    tempF.close();
    _gnu.rePlot();  
}

