// GENVAR.HPP : Variable length genotype base class

// Referencia : algoritmo g-lvq en mi tesis

// Historia:	La versin funciona bien en julio 93; aadidas cosas
// =========	en Septiembre-93
// 29-Nov-93	Aadida la variable pruned; que indica si ya se ha
//		llevado a cabo alguna operacin de variacin de
// 		longitud. Aadida la funcin de informacin corres-
//		pondiente, y modificados todos los mtodos
// 1-Dic-93	Aadido reset(), para poner pruned a 0.
// 6-Dic-93  	Aadida comprobacin de errores, tamao de alelo 0 y
//		tamao de gen 0
// 18-Mar-94	Eliminada la definicion de myrand, pasada a general.hpp
//		Una funcion mas: forcePruned, para que no se le aplique
//		otra vez el podado
// 20-Mar-94	Aniadidos un nuevo constructor, para construir un genoma
//		a partir de uno anterior aplicando uno de los tres opera
//		dores geneticos: dup, kill y randInc. Aniadido el tipo
//		enum correspondiente
// 23-Mar-94	Eliminado todo lo de pruned
// 12-Abr-94	Cambiados todos los deletes, incluyendo los corchetes
//  4-May-94	Pequeas modificaciones cosmeticas
//  5-May-94	Aniadido crossover 2 puntos y swapByte, con constructores
//		correspondientes
//  6-May-94	Corregido xover 2 puntos, parece, y aniadidas funciones C++
//		de I/O.
//		Todas las funciones de informacion declaradas como _const_
//		Definicion de tabla de bits movida a la cabecera
// 10-May-94	Aniadido maxForSize, numero maximo para el tamanio de cada
//		alelo.


#ifndef __GENVAR_HPP
#define __GENVAR_HPP

#include "general.hpp"


// definition of enumerated types
enum varLenOpMode { DUP, KILL, RANDINC };

const unsigned char Wgts[9] = { 0,128,64,32,16,8,4,2,1 };




// ---------------------------------------------------------------------------
// -------------------------- Class definition -------------------------------

class genVar {

protected:

	char *str; 			// contains the genVar itself
	unsigned length; 		// length of the genome, in bytes
	unsigned size;			// size of each allele, in bytes
	unsigned long maxForSize;	// max number code-able with this locus size

	void checkNassign( unsigned _numAlleles, unsigned _sizeAllele);
					// underground constructor
					
	void mutate( double _mutationRate);
					// mutates with given mutationRate
					
					
					
	// Friend declaration
	friend ostream& operator << ( ostream& s, const genVar & _inGen );
	
public:
	// several constructors, and one destructor

	genVar( void ) {}; 		// default constructor


	// more or less random constructors
	genVar( unsigned _numAlleles, unsigned _sizeAllele );
	genVar( char *inStr, unsigned _numAlleles, unsigned _sizeAllele );
	genVar( char *_str, unsigned _length, float _mutationRate );
	
	
	// "binary" constructors, from two loving parents
	genVar( genVar &genVar1, genVar &genVar2,
		double xOverRate, double MutationRate ); // normal reproduction
	genVar( genVar &genVar1, genVar &genVar2,
		double xOverRate, double MutationRate, double killRate, double dupRate );
	genVar( genVar &genVar1, genVar &genVar2, double xOverRate );
	genVar( genVar &genVar1, genVar &genVar2, 
		unsigned _startPoint, unsigned _endPoint, 
		double _mutationRate);
							// 2-point crossover
	
	// "unary" constructors, from batchelor parent or from an amoeba
	genVar( genVar &genVar1, double MutationRate);
	genVar( genVar &genVar1, double MutationRate, double killRate, double dupRate);
	genVar( genVar &genVar1, varLenOpMode _modeOp, 
		unsigned _geneIdx = 0, double _mutationRate = 0);	
							// creates a new genome using one
							// of 3 modes; using _geneIdx if
							// needed and _mutationRate

	~genVar() {
		delete []str;
	//	printf( "Destruido..." );
	} ;

	// other functions

	// genetic operators
	void		changeBit	( unsigned long chBit);
	void		swapBit		( unsigned long swBit, char* inStr);
	void		swapChunkByte	(   unsigned char _scbStart,
					    unsigned char _scbEnd, 
					    unsigned _idxByte, 
					    char _scbByte);
					    
	void		swapChunk	(   unsigned long _swBitStart,
					    unsigned long _swBitEnd,
					    char *inStr );
					    
	// info functions
	unsigned 	getLength() const 	{return length;} ;
	unsigned 	getSize() const		{return size;} ;
	char* 		getGenome() const	{return str;} ;
	
	void 		getAllele( unsigned idx, char* _inStr ) const;
	char*		getAllele( unsigned idx) const;
	
	unsigned 	getNumAlleles( void ) const
	    { return length/size;} ;
	    
	void		print( void );

	char operator [] ( unsigned idx ) const { return str[idx];}; // return only 1 char

	// variable length functions
	void 		addAllele( );
	void 		killAllele( unsigned _pos );
	void 		dupAllele( unsigned _pos, double MutationRate );
};

typedef genVar* pGenVar;


// friendly operators
// ------------------
ostream& operator << ( ostream& s, const genVar & _inGen );
#endif
